/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.filter;

import com.atlassian.confluence.plugins.mobile.analytic.MobileSimpleAnalyticEvent;
import com.atlassian.confluence.plugins.mobile.notification.PushNotificationStatus;
import com.atlassian.confluence.plugins.mobile.service.PushNotificationService;
import com.atlassian.event.api.EventPublisher;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public final class ServerInfoFilter
implements Filter {
    private static final String MOBILE_PLUGIN_ENABLED = "mobile-plugin-enabled";
    private static final String PUSH_NOTIFICATION_ENABLED = "push-notification-enabled";
    private static final String MOBILE_LOGIN_OPEN_EVENT_NAME = "login.open";
    private final EventPublisher eventPublisher;
    private final PushNotificationService pushNotificationService;

    public ServerInfoFilter(EventPublisher eventPublisher, PushNotificationService pushNotificationService) {
        this.eventPublisher = eventPublisher;
        this.pushNotificationService = pushNotificationService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader(MOBILE_PLUGIN_ENABLED, "true");
        response.setHeader(PUSH_NOTIFICATION_ENABLED, String.valueOf(this.pushNotificationService.getStatus() == PushNotificationStatus.ENABLED));
        this.eventPublisher.publish((Object)new MobileSimpleAnalyticEvent(MOBILE_LOGIN_OPEN_EVENT_NAME));
        filterChain.doFilter(servletRequest, (ServletResponse)response);
    }

    public void destroy() {
    }
}

