/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.condition;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MobileAppResourceCondition
implements UrlReadingCondition {
    private static final String MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY = "mobile-app-login-resource";

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isMobileAppLogin()) {
            urlBuilder.addToQueryString(MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY, "true");
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.valueOf(queryParams.get(MOBILE_APP_LOGIN_RESOURCE_QUERY_PARAM_KEY));
    }

    private boolean isMobileAppLogin() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request == null) {
            return false;
        }
        String userAgent = request.getHeader("User-Agent");
        return userAgent.contains("AtlassianMobileApp");
    }
}

