/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.plugins.mobile.dto.NotificationDto;
import com.atlassian.confluence.plugins.mobile.helper.NotificationHelper;
import com.atlassian.confluence.plugins.mobile.service.MobileNotificationService;
import com.atlassian.confluence.rest.api.model.RestPageRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/notification")
@Component
public class NotificationResource {
    private static final String APP_ID_PARAM = "appId=";
    private final MobileNotificationService notificationService;
    private final InternalHostApplication internalHostApplication;

    @Autowired
    public NotificationResource(MobileNotificationService notificationService, @ComponentImport InternalHostApplication internalHostApplication) {
        this.notificationService = notificationService;
        this.internalHostApplication = internalHostApplication;
    }

    @GET
    @Path(value="/{id}")
    public NotificationDto getNotification(@PathParam(value="id") long id) {
        return this.notificationService.getNotification(id);
    }

    @GET
    public PageResponse<NotificationDto> getNotifications(@QueryParam(value="from") @DefaultValue(value="0") long from, @QueryParam(value="to") @DefaultValue(value="0") long to, @QueryParam(value="notificationId") List<Long> notificationIds, @QueryParam(value="pageId") List<Long> pageIds, @QueryParam(value="action") List<String> actions, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit, @Context UriInfo uriInfo) {
        String appId = APP_ID_PARAM + this.internalHostApplication.getId().get();
        if (actions == null || actions.isEmpty()) {
            actions = NotificationHelper.WORKBOX_ACTION_LIST;
        }
        return this.notificationService.getNotifications(NotificationHelper.build(from, to, notificationIds, pageIds, actions, appId), (PageRequest)new RestPageRequest(uriInfo, start, limit));
    }

    @POST
    @Path(value="/read")
    public Response readNotifications(@QueryParam(value="from") @DefaultValue(value="0") long from, @QueryParam(value="to") @DefaultValue(value="0") long to, @QueryParam(value="notificationId") List<Long> notificationIds, @QueryParam(value="pageId") List<Long> pageIds, @QueryParam(value="action") List<String> actions) {
        this.notificationService.readNotifications(NotificationHelper.build(from, to, notificationIds, pageIds, actions, null));
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteNotifications(@QueryParam(value="from") @DefaultValue(value="0") long from, @QueryParam(value="to") @DefaultValue(value="0") long to, @QueryParam(value="notificationId") List<Long> notificationIds, @QueryParam(value="pageId") List<Long> pageIds, @QueryParam(value="action") List<String> actions) {
        this.notificationService.deleteNotification(NotificationHelper.build(from, to, notificationIds, pageIds, actions, null));
        return Response.noContent().build();
    }
}

