/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.notification;

import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;

public final class NotificationCategory
extends BaseApiEnum {
    public static final NotificationCategory COMMENT = new NotificationCategory(0, "comment", 0);
    public static final NotificationCategory COMMENT_REPLY = new NotificationCategory(1, "comment-reply", 0);
    public static final NotificationCategory COMMENT_CONTENT_CREATOR = new NotificationCategory(2, "comment-contentcreator", 0);
    public static final NotificationCategory MENTION_PAGE = new NotificationCategory(3, "mention-page", 2);
    public static final NotificationCategory MENTION_BLOGPOST = new NotificationCategory(4, "mention-blogpost", 2);
    public static final NotificationCategory MENTION_COMMENT = new NotificationCategory(5, "mention-comment", 2);
    public static final NotificationCategory SHARE = new NotificationCategory(6, "share", 2);
    public static final NotificationCategory SHARE_GROUP = new NotificationCategory(7, "share-group", 1);
    public static final NotificationCategory TASK_ASSIGN = new NotificationCategory(8, "task-assign", 2);
    public static final NotificationCategory LIKE_PAGE = new NotificationCategory(9, "like-page", 0);
    public static final NotificationCategory LIKE_BLOGPOST = new NotificationCategory(10, "like-blogpost", 0);
    public static final NotificationCategory LIKE_COMMENT = new NotificationCategory(11, "like-comment", 0);
    public static final NotificationCategory CREATE_PAGE = new NotificationCategory(12, "create-page", 0);
    public static final NotificationCategory CREATE_BLOG_POST = new NotificationCategory(13, "create-blogpost", 0);
    public static final NotificationCategory EDIT_PAGE = new NotificationCategory(14, "edit-page", 0);
    public static final NotificationCategory EDIT_BLOG_POST = new NotificationCategory(15, "edit-blogpost", 0);
    public static final List<NotificationCategory> BUILT_IN = Collections.unmodifiableList(Arrays.asList(COMMENT, COMMENT_REPLY, COMMENT_CONTENT_CREATOR, MENTION_PAGE, MENTION_BLOGPOST, MENTION_COMMENT, SHARE, SHARE_GROUP, TASK_ASSIGN, LIKE_PAGE, LIKE_BLOGPOST, LIKE_COMMENT, CREATE_PAGE, CREATE_BLOG_POST, EDIT_PAGE, EDIT_BLOG_POST));
    private int settingPosition;
    private int priority;

    public NotificationCategory(int settingPosition, String value, int priority) {
        super(value);
        this.settingPosition = settingPosition;
        this.priority = priority;
    }

    public int getSettingPosition() {
        return this.settingPosition;
    }

    public int getPriority() {
        return this.priority;
    }

    @JsonCreator
    public static NotificationCategory valueOf(@Nullable String value) {
        return BUILT_IN.stream().filter(category -> category.serialise().equals(value)).findFirst().orElse(null);
    }

    public static NotificationCategory getMentionCategory(ContentType contentType) {
        if (ContentType.PAGE.equals((Object)contentType)) {
            return MENTION_PAGE;
        }
        if (ContentType.BLOG_POST.equals((Object)contentType)) {
            return MENTION_BLOGPOST;
        }
        if (ContentType.COMMENT.equals((Object)contentType)) {
            return MENTION_COMMENT;
        }
        throw new ServiceException(contentType + " is not supported");
    }

    public static NotificationCategory getLikeCategory(ContentType contentType) {
        if (ContentType.PAGE.equals((Object)contentType)) {
            return LIKE_PAGE;
        }
        if (ContentType.BLOG_POST.equals((Object)contentType)) {
            return LIKE_BLOGPOST;
        }
        if (ContentType.COMMENT.equals((Object)contentType)) {
            return LIKE_COMMENT;
        }
        throw new ServiceException(contentType + " is not supported");
    }
}

