/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.content.ui.ContentUiSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.MaybeNot;
import com.atlassian.confluence.internal.ContentEntityManagerInternal;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugins.mentions.notifications.MentionContentPayload;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;

public class MentionRenderContextFactory
extends RenderContextProviderTemplate<MentionContentPayload> {
    private final ContentEntityManagerInternal contentEntityManager;
    private final ContentUiSupport<ContentEntityObject> contentUiSupport;
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;
    private final PermissionManager permissionManager;
    private final NotificationUserService notificationUserService;

    public MentionRenderContextFactory(ContentEntityManagerInternal contentEntityManager, ContentUiSupport<ContentEntityObject> contentUiSupport, UserAccessor userAccessor, TransactionTemplate transactionTemplate, PermissionManager permissionManager, NotificationUserService notificationUserService) {
        this.contentEntityManager = contentEntityManager;
        this.contentUiSupport = contentUiSupport;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.permissionManager = permissionManager;
        this.notificationUserService = notificationUserService;
    }

    protected Maybe<Map<String, Object>> checkedCreate(Notification<MentionContentPayload> mentionContentPayloadNotification, ServerConfiguration configuration, Maybe<Either<NotificationAddress, RoleRecipient>> roleRecipient) {
        Option<Pair<Content, String>> maybeContentForId;
        if (roleRecipient.isEmpty() || ((Either)roleRecipient.get()).isLeft()) {
            return MaybeNot.becauseOf((String)"This factory exposes content, thus recipient has to be provided in order to perform a VIEW permission check.", (Object[])new Object[0]);
        }
        RoleRecipient recipient = (RoleRecipient)((Either)roleRecipient.get()).right().get();
        ConfluenceUser recipientUser = this.userAccessor.getUserByKey(recipient.getUserKey());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        MentionContentPayload payload = (MentionContentPayload)mentionContentPayloadNotification.getPayload();
        if (payload.getMentionHtml().isDefined()) {
            renderContext.put("contentHtml", payload.getMentionHtml().get());
        }
        if ((maybeContentForId = this.getContentDetailsForId(payload.getContentId(), recipient.getUserKey())).isEmpty()) {
            return MaybeNot.becauseOf((String)("Unable to load content with id " + payload.getContentId() + " may not permissionto view the content"), (Object[])new Object[0]);
        }
        Pair contentForId = (Pair)maybeContentForId.get();
        Content content = (Content)contentForId.left();
        String contentType = (String)contentForId.right();
        renderContext.put("content", content);
        renderContext.put("contentType", contentType);
        if ("comment".equals(contentType)) {
            renderContext.put("messageId", String.valueOf(((Content)content.getContainer()).getId().asLong()));
        } else {
            renderContext.put("messageId", String.valueOf(content.getId().asLong()));
        }
        renderContext.put("modifier", this.notificationUserService.findUserForKey((User)recipientUser, payload.getAuthorUserKey()));
        return Option.some(renderContext);
    }

    @Deprecated
    private Option<Pair<Content, String>> getContentDetailsForId(long id, UserKey recipient) {
        return (Option)this.transactionTemplate.execute(() -> {
            ContentEntityObject content = this.contentEntityManager.getById(id);
            ConfluenceUser user = this.userAccessor.getUserByKey(recipient);
            if (this.permissionManager.hasPermissionNoExemptions((User)user, Permission.VIEW, (Object)content)) {
                ContentId contentId = ContentId.of((ContentType)ContentType.PAGE, (long)id);
                return Option.some((Object)Pair.pair((Object)Content.builder().id(contentId).title(content.getDisplayTitle()).addLink(LinkType.WEB_UI, content.getUrlPath()).build(), (Object)this.contentUiSupport.getContentTypeI18NKey((ConfluenceEntityObject)content)));
            }
            return Option.none();
        });
    }
}

