package com.atlassian.confluence.plugins.mentions.conditions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugin.descriptor.mail.conditions.AbstractNotificationCondition;

/**
 * Checks whether we should display the view page button action in a mention email
 */
public class ShowViewBlogPostLinkCondition extends AbstractNotificationCondition {
    @Override
    protected boolean shouldDisplay(NotificationContext context) {
        return context.getContent() instanceof AbstractPage && BlogPost.CONTENT_TYPE.equals(((AbstractPage) context.getContent()).getType());
    }
}