package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.render.xhtml.storage.InlineTasksUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Maybe;

import javax.activation.DataSource;

public class NotificationEmailFactoryImpl implements NotificationEmailFactory {
    private DataSourceFactory imageDataSourceFactory;

    public NotificationEmailFactoryImpl(DataSourceFactory imageDataSourceFactory) {
        this.imageDataSourceFactory = imageDataSourceFactory;
    }

    @Override
    public PreRenderedMailNotificationQueueItem create(ContentEntityObject contentEntityObject, ConfluenceUser recipient, ConfluenceUser sender, String templateLocation, String templateName, String subject, NotificationContext context) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with(recipient, templateName, subject).andSender(sender)
                .andTemplateLocation(templateLocation).andContext(context.getMap());

        Maybe<PluginDataSourceFactory> pluginFactory = imageDataSourceFactory.forPlugin("com.atlassian.confluence.plugins.confluence-mentions-plugin");
        if (pluginFactory.isDefined()) {
            Maybe<DataSource> mention_icon = pluginFactory.get().resourceFromModuleByName("mention-icon", "mention-icon");
            if (mention_icon.isDefined()) {
                context.addTemplateImage(mention_icon.get());
            }
        }

        String mentionExcerpt = (String) context.get("contentHtml");
        for (DataSource resource : InlineTasksUtils.getRequiredResources(imageDataSourceFactory, mentionExcerpt)) {
            context.addTemplateImage(resource);
        }

        builder.andRelatedBodyParts(context.getTemplateImageDataSources()).andRelatedBodyParts(imagesUsedByChromeTemplate());

        return builder.render();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        return imageDataSourceFactory.forPlugin("com.atlassian.confluence.plugins.confluence-email-resources")
                .get().resourcesFromModules("chrome-template", PluginDataSourceFactory.FilterByType.IMAGE).get();
    }
}
