/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.content;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.mail.address.ConfluenceMailAddress;
import com.atlassian.confluence.mail.archive.content.ContentBackedMail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class MailSearchExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof CustomContentEntityObject) {
            CustomContentEntityObject contentEntityObject = (CustomContentEntityObject)searchable;
            if (!ContentBackedMail.isMailContentEntity(contentEntityObject)) {
                return;
            }
            ContentBackedMail mail = ContentBackedMail.newInstance(contentEntityObject);
            document.add((IndexableField)new Field("canonicalsubject", mail.getCanonicalSubject(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((IndexableField)new Field("messageid", mail.getMessageId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((IndexableField)new Field("inreplyto", mail.getInReplyTo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            for (String reference : mail.getReferences()) {
                document.add((IndexableField)new Field("references", reference, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            for (String addressPart : this.toAddressParts(mail.getFrom())) {
                document.add((IndexableField)new Field("from", addressPart, Field.Store.NO, Field.Index.ANALYZED));
            }
            for (String addressPart : this.toAddressParts(mail.getRecipients())) {
                document.add((IndexableField)new Field("recipients", addressPart, Field.Store.NO, Field.Index.ANALYZED));
            }
        }
    }

    private List<String> toAddressParts(Collection<ConfluenceMailAddress> addresses) {
        ArrayList<String> addressBits = new ArrayList<String>();
        for (ConfluenceMailAddress address : addresses) {
            addressBits.add(address.toString());
        }
        return addressBits;
    }

    private List<String> toAddressParts(ConfluenceMailAddress from) {
        return this.toAddressParts(Collections.singleton(from));
    }
}

