/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.actions;

import com.atlassian.confluence.mail.archive.MailAccount;
import com.atlassian.confluence.mail.archive.actions.AbstractMailAccountAction;
import com.atlassian.confluence.util.HTMLPairType;
import java.util.ArrayList;
import java.util.List;

public class EditMailAccountAction
extends AbstractMailAccountAction {
    private int id;

    public String doDefault() throws Exception {
        MailAccount mailAccount = this.mailAccountManager.getMailAccount(this.getSpace(), this.getId());
        this.setName(mailAccount.getName());
        this.setDescription(mailAccount.getDescription());
        this.setHostname(mailAccount.getHostname());
        this.setProtocol(mailAccount.getProtocol());
        this.setUsername(mailAccount.getUsername());
        this.setPassword(mailAccount.getPassword());
        this.setPort(mailAccount.getPort());
        this.setSecure(mailAccount.isSecure());
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (this.getTestConnection() != null) {
            MailAccount mailAccount = this.createMailAccountFromFormData();
            this.pollResult = this.mailAccountManager.updateAccountStatus(mailAccount);
            return "testconnection";
        }
        MailAccount mailAccount = this.mailAccountManager.getMailAccount(this.getSpace(), this.getId());
        mailAccount.setName(this.getName());
        mailAccount.setDescription(this.getDescription());
        mailAccount.setHostname(this.getHostname());
        mailAccount.setUsername(this.getUsername());
        mailAccount.setPassword(this.getPassword());
        mailAccount.setPort(this.getPort());
        mailAccount.setSecure(this.isSecure());
        if (this.getProtocol().endsWith("s")) {
            mailAccount.setSecure(true);
        }
        this.mailAccountManager.updateAccountStatus(mailAccount);
        this.mailAccountManager.updateAccount(this.getSpace(), mailAccount);
        return "success";
    }

    public List<HTMLPairType> getProtocolList() {
        ArrayList<HTMLPairType> result = new ArrayList<HTMLPairType>();
        if (this.getProtocol().indexOf("pop3") != -1) {
            result.add(new HTMLPairType("pop3", "POP"));
            result.add(new HTMLPairType("pop3s", "POPS"));
        } else if (this.getProtocol().indexOf("imap") != -1) {
            result.add(new HTMLPairType("imap", "IMAP"));
            result.add(new HTMLPairType("imaps", "IMAPS"));
        } else {
            throw new UnsupportedOperationException(this.getProtocol() + " no supported.");
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean isEditAction() {
        return true;
    }
}

