/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.mail.archive.ThreadNode;
import com.atlassian.confluence.search.lucene.filter.TermFilter;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThreadBuilder.class);
    private static final Integer THREAD_SIZE_LIMIT = Integer.getInteger("confluence.mail.archive.thread.limit", 1000);
    private static final ImmutableSet<String> REQUIRED_FIELDS = ImmutableSet.of((Object)"handle", (Object)"title", (Object)"canonicalsubject", (Object)"references", (Object)"messageid", (Object)"from", (Object[])new String[]{"created"});
    private final ILuceneConnection luceneConnection;
    private Stack<String> toLookUp = new Stack();
    private Set<String> lookedUp = new HashSet<String>();
    private Map<String, Document> docs = new HashMap<String, Document>();
    private Map<String, Document> docCache = new HashMap<String, Document>();
    private String spaceKey;
    private boolean called;
    private Set<String> searchedSubjects = new HashSet<String>();
    private String originalMessageId;

    public ThreadBuilder(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public ThreadNode buildThreadAround(String spaceKey, String messageId) {
        this.checkNotAlreadyUsed();
        this.originalMessageId = messageId;
        UtilTimerStack.push((String)("ThreadBuilder: " + messageId));
        this.spaceKey = spaceKey;
        this.findAllMailRelatedTo(messageId);
        ThreadNode returnValue = this.buildThreadFromDocuments(this.docs);
        UtilTimerStack.pop((String)("ThreadBuilder: " + messageId));
        return returnValue;
    }

    private void findAllMailRelatedTo(String messageId) {
        log.debug("Finding related mail to {} via Lucene", (Object)messageId);
        this.toLookUp.add(messageId);
        while (!this.toLookUp.isEmpty()) {
            this.processNextId();
        }
    }

    private void processNextId() {
        String messageId = this.toLookUp.pop();
        this.addThisDoc(messageId);
        if (this.docs.size() + this.toLookUp.size() >= THREAD_SIZE_LIMIT) {
            return;
        }
        this.addDocsReferencingThisToQueue(messageId);
    }

    private void addDocsReferencingThisToQueue(String messageId) {
        BooleanFilter filter = new BooleanFilter();
        filter.add((Filter)new TermFilter(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("classname", CustomContentEntityObject.class.getName())), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("contentPluginKey", "com.atlassian.confluence.plugins.confluence-mail-archiving:mail")), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("references", messageId)), BooleanClause.Occur.MUST);
        this.luceneConnection.withReader(reader -> {
            for (AtomicReaderContext context : reader.leaves()) {
                DocIdSet set = filter.getDocIdSet(context, context.reader().getLiveDocs());
                if (set == null) continue;
                DocIdSetIterator iterator = set.iterator();
                while (iterator.nextDoc() != Integer.MAX_VALUE) {
                    int docId = iterator.docID();
                    Document doc = context.reader().document(docId, REQUIRED_FIELDS);
                    String referencingMessageId = doc.get("messageid");
                    this.docCache.put(referencingMessageId, doc);
                    this.addIdToSearchList(referencingMessageId);
                }
            }
            return null;
        });
    }

    private ThreadNode buildThreadFromDocuments(Map<String, Document> docs) {
        log.debug("Trying to build tree based on references. |docs| = {}", (Object)docs.size());
        Map<String, ThreadNode> nodesById = this.toNodeMap(docs);
        docs.forEach((messageId, doc) -> {
            String[] references = doc.getValues("references");
            if (references != null && references.length > 0) {
                this.linkReferencedMessages(nodesById, (String)messageId, references);
            }
        });
        return this.makeSingleRootedThread(nodesById);
    }

    private ThreadNode makeSingleRootedThread(Map<String, ThreadNode> nodesById) {
        List<ThreadNode> orphanNodes = this.getOrphanNodes(nodesById);
        if (orphanNodes.size() > 1) {
            this.cleanOrphanNodesBySubject(nodesById.values(), orphanNodes);
            log.debug("{} orphaned nodes left after trying to link them by subject", (Object)orphanNodes.size());
        } else {
            log.debug("No orphaned nodes has been found");
        }
        ThreadNode rootNode = orphanNodes.stream().filter(node -> node.getNodeWithMessageId(this.originalMessageId) != null).findFirst().orElse(ThreadNode.getEmptyThreadNode());
        log.debug("Tree of {} nodes has been completely built", (Object)nodesById.size());
        return rootNode;
    }

    private void cleanOrphanNodesBySubject(Collection<ThreadNode> allNodes, List<ThreadNode> orphanNodes) {
        log.debug("Building tree based on subject. |allNodes|={}, |orphanNodes|={}", (Object)allNodes.size(), (Object)orphanNodes.size());
        Iterator<ThreadNode> it = orphanNodes.iterator();
        while (it.hasNext()) {
            ThreadNode threadNode = it.next();
            ThreadNode parent = this.findPossibleParentBySubject(threadNode, allNodes);
            if (parent == null) continue;
            threadNode.setParent(parent);
            if (threadNode.getParent() == null) continue;
            it.remove();
        }
    }

    private ThreadNode findPossibleParentBySubject(ThreadNode orphanedNode, Collection<ThreadNode> allNodes) {
        return allNodes.stream().filter(potentialParent -> potentialParent != orphanedNode && StringUtils.isNotBlank((CharSequence)orphanedNode.getCanonicalSubject()) && orphanedNode.getCanonicalSubject().equals(potentialParent.getTitle())).findFirst().orElse(null);
    }

    private void linkReferencedMessages(Map<String, ThreadNode> nodesById, String messageId, String[] references) {
        if (nodesById.containsKey(references[references.length - 1])) {
            nodesById.get(messageId).setParent(nodesById.get(references[references.length - 1]));
        } else if (references.length > 1) {
            for (int i = references.length - 2; i >= 0; --i) {
                if (!nodesById.containsKey(references[i])) continue;
                ThreadNode dummyParent = ThreadNode.getEmptyThreadNode();
                nodesById.get(messageId).setParent(dummyParent);
                dummyParent.setParent(nodesById.get(references[references.length - 1]));
                break;
            }
        }
    }

    private Map<String, ThreadNode> toNodeMap(Map<String, Document> docs) {
        return docs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ThreadNode(this.toId(((Document)entry.getValue()).get("handle")), (Document)entry.getValue())));
    }

    private void addThisDoc(String messageId) {
        this.lookedUp.add(messageId);
        if (this.docCache.containsKey(messageId)) {
            this.addThisDoc(messageId, this.docCache.get(messageId));
        } else {
            this.searchAndAddThisDoc(messageId);
        }
    }

    private void searchAndAddThisDoc(String messageId) {
        BooleanFilter filter = new BooleanFilter();
        filter.add((Filter)new TermFilter(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("messageid", messageId)), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("classname", CustomContentEntityObject.class.getName())), BooleanClause.Occur.MUST);
        filter.add((Filter)new TermFilter(new Term("contentPluginKey", "com.atlassian.confluence.plugins.confluence-mail-archiving:mail")), BooleanClause.Occur.MUST);
        this.luceneConnection.withReader(reader -> {
            for (AtomicReaderContext context : reader.leaves()) {
                DocIdSet set = filter.getDocIdSet(context, context.reader().getLiveDocs());
                if (set == null) continue;
                DocIdSetIterator iterator = set.iterator();
                while (iterator.nextDoc() != Integer.MAX_VALUE) {
                    int docId = iterator.docID();
                    Document doc = context.reader().document(docId, REQUIRED_FIELDS);
                    this.addThisDoc(messageId, doc);
                }
            }
            return null;
        });
    }

    private void addThisDoc(String messageId, Document doc) {
        this.docs.put(messageId, doc);
        if (this.docs.size() + this.toLookUp.size() >= THREAD_SIZE_LIMIT) {
            return;
        }
        this.addReferencedMessages(doc);
        String canonicalSubject = doc.get("canonicalsubject");
        if (StringUtils.isNotBlank((CharSequence)canonicalSubject)) {
            this.addMessagesWithSameSubject(canonicalSubject);
        }
    }

    private void addMessagesWithSameSubject(String canonicalSubject) {
        if (!this.searchedSubjects.contains(canonicalSubject)) {
            this.searchedSubjects.add(canonicalSubject);
            BooleanFilter filter = new BooleanFilter();
            filter.add((Filter)new TermFilter(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
            filter.add((Filter)new TermFilter(new Term("canonicalsubject", canonicalSubject)), BooleanClause.Occur.MUST);
            filter.add((Filter)new TermFilter(new Term("classname", CustomContentEntityObject.class.getName())), BooleanClause.Occur.MUST);
            filter.add((Filter)new TermFilter(new Term("contentPluginKey", "com.atlassian.confluence.plugins.confluence-mail-archiving:mail")), BooleanClause.Occur.MUST);
            this.luceneConnection.withReader(reader -> {
                for (AtomicReaderContext context : reader.leaves()) {
                    DocIdSet set = filter.getDocIdSet(context, context.reader().getLiveDocs());
                    if (set == null) continue;
                    DocIdSetIterator iterator = set.iterator();
                    while (iterator.nextDoc() != Integer.MAX_VALUE) {
                        int docId = iterator.docID();
                        Document doc = context.reader().document(docId, REQUIRED_FIELDS);
                        this.docCache.put(doc.get("messageid"), doc);
                        this.addIdToSearchList(doc.get("messageid"));
                    }
                }
                return null;
            });
        }
    }

    private void addReferencedMessages(Document doc) {
        String[] referencedDocs = doc.getValues("references");
        if (referencedDocs != null) {
            for (String referencedId : referencedDocs) {
                this.addIdToSearchList(referencedId);
            }
        }
    }

    private long toId(String value) {
        return Long.parseLong(value.substring(CustomContentEntityObject.class.getName().length() + 1));
    }

    private void addIdToSearchList(String messageId) {
        if (!this.toLookUp.contains(messageId) && !this.lookedUp.contains(messageId) && this.toLookUp.size() + this.docs.size() < THREAD_SIZE_LIMIT) {
            this.toLookUp.add(messageId);
        }
    }

    private List<ThreadNode> getOrphanNodes(Map<String, ThreadNode> nodesById) {
        return nodesById.values().stream().filter(node -> node.getParent() == null).collect(Collectors.toList());
    }

    private void checkNotAlreadyUsed() {
        if (this.called) {
            throw new IllegalStateException("Attempting to re-use a single-use object");
        }
        this.called = true;
    }
}

