/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.jobs;

import com.atlassian.confluence.mail.archive.jobs.MailPollJobDetail;
import com.atlassian.quartz.jobs.AbstractJob;
import com.atlassian.sal.api.transaction.TransactionCallback;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPollJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(MailPollJob.class);
    private static final String SYSTEM_PROPERTY_DISABLE_POLLING = "confluence.disable.mailpolling";

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_POLLING)) {
            log.info("Mail polling disabled.");
            return;
        }
        final MailPollJobDetail jobDetail = (MailPollJobDetail)jobExecutionContext.getJobDetail();
        jobDetail.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                jobDetail.getMailAccountManager().pollAllSpaces();
                return null;
            }
        });
    }
}

