/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.actions;

import com.atlassian.confluence.mail.archive.MboxImporter;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.io.ConfluenceFileUtils;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.xwork.FileUploadUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Category;

@WebSudoRequired
public class ImportMboxAction
extends AbstractSpaceAdminAction {
    public static final Category log = Category.getInstance(ImportMboxAction.class);
    private MboxImporter mboxImporter;
    private File uploadedFile;
    private String fileName;
    public boolean nonBackgroundTask;

    public void setMboxImporter(MboxImporter mboxImporter) {
        this.mboxImporter = mboxImporter;
    }

    public void validate() {
        super.validate();
        if (this.getSpace() == null) {
            log.warn((Object)"space is null");
            this.addActionError(this.getText("space.doesnt.exist"));
        }
        try {
            if (this.getFile() == null) {
                this.addActionError(this.getText("no.file.uploaded"));
            } else if (!this.validateMboxFile(this.getFile())) {
                this.addActionError(this.getText("invalid.format"));
            }
        }
        catch (FileUploadUtils.FileUploadException e) {
            String[] errors = e.getErrors();
            for (int i = 0; i < errors.length; ++i) {
                this.addActionError(GeneralUtil.getUploadFileTooLargeMessage((String)e.getErrors()[i]));
            }
        }
        catch (IOException e) {
            this.addActionError(this.getText("invalid.file"));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean validateMboxFile(File mboxFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String execute() throws Exception {
        this.mboxImporter.setSpace(this.space);
        this.mboxImporter.setFile(this.getFile());
        if (!this.nonBackgroundTask) {
            LongRunningTaskUtils.startTask((LongRunningTask)this.mboxImporter);
        } else {
            this.mboxImporter.runInternal();
        }
        return "success";
    }

    private File getFile() throws FileUploadUtils.FileUploadException {
        try {
            if (this.uploadedFile == null) {
                this.uploadedFile = FileUploadUtils.getSingleFile();
            }
            if (this.uploadedFile == null && this.fileName != null) {
                File temp = new File(this.fileName);
                String mboxDirPath = System.getProperty("confluence.mbox.directory");
                if (mboxDirPath == null || mboxDirPath.isEmpty()) {
                    log.warn((Object)"Mail import directory is not configured, please set the 'confluence.mbox.directory' system property");
                    return null;
                }
                File mboxDir = new File(mboxDirPath);
                if (!ConfluenceFileUtils.isChildOf((File)mboxDir, (File)temp)) {
                    log.warn((Object)("Cannot import mail from outside of the configured mbox directory " + mboxDirPath));
                    return null;
                }
                this.uploadedFile = temp;
            }
        }
        catch (ClassCastException e) {
            log.error((Object)"Exception occurred when accessing file", (Throwable)e);
        }
        return this.uploadedFile;
    }

    public boolean getNonBackgroundTask() {
        return this.nonBackgroundTask;
    }

    public void setNonBackgroundTask(boolean nonBackgroundTask) {
        this.nonBackgroundTask = nonBackgroundTask;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

