/**
 * TODO: copied implementation from jira-integration-plugin/jira-create-issue-form-data.js (https://stash.atlassian.com/projects/CP/repos/jira-integration-plugin/browse/plugin/src/main/resources/jira-create-issue-form/jira-create-issue-form-data.js?at=refs%2Fheads%2Frelease%2F1.4.x)
 * as now it is not a generic create issue data api for can in this plugin.
 * replace this when jira-create-issue-form-data.js becomes a generic create issue data api: https://jira.atlassian.com/browse/CONFDEV-23519
 */

define('confluence/cjc/jira-issue-data-helper', [
    'jquery',
    'ajs',
    'underscore'
],
function(
    $,
    AJS,
    _
) {
    'use strict';

    // XHR object, hold ajax get fields request to call abort when needed
    var xhrProject;
    var servers = {},
        securedIconUrl = AJS.contextPath() + '/plugins/servlet/jira-integration/icons?serverId={0}&iconType={1}&{2}',
        imagesCache = {};

    var getJSON = function(url, successCallback) {
        return $.ajax({
            dataType: 'json',
            timeout: 0,
            url: url,
            success: successCallback
        });
    };

    function loadServers() {
        return getJSON(AJS.Confluence.getContextPath() + '/rest/createjiracontent/1.0/get-jira-servers',
            function(data) {
                if (data.length) {
                    $.each(data, function(index, server) {
                        servers[server.id] = server;
                    });
                }
            }
        );
    }

    function loadProjects(serverId) {
        var projectData = (servers[serverId]) ? servers[serverId].projects : undefined;
        if (projectData) {
            return $.Deferred().resolve(projectData);
        }

        // If xhrProject is existed, this mean previous ajax hadn't completed yet, call abort() to cancel it.
        if (xhrProject && xhrProject.readyState !== 4 && xhrProject.abort) {
            xhrProject.abort();
        }

        xhrProject = getJSON(AJS.contextPath() + '/rest/jira-integration/1.0/servers/' + serverId + '/projects',
            function(data) {
                if (data.length) {
                    $.each(data, function(index, project) {
                        var issueTypes = _.filter(project.issuetypes, function(item) { // Do not allow to create a sub-task
                            return !item.subtask;
                        });
                        project.issueTypes = issueTypes;

                        // build images cache for project avatar and issue type icons
                        var issueTypeIcons = {};
                        _.each(issueTypes, function(item) {
                            issueTypeIcons[item.id] = item.iconUrl;
                        });

                        var projectIconParams = project.avatarUrls['16x16'].split("/secure/projectavatar?")[1];
                        if (projectIconParams.indexOf("pid=") === -1) {
                            projectIconParams = projectIconParams + "&pid=" + project.id;
                        }

                        var projectImagesCache = {
                            iconUrl: AJS.format(securedIconUrl, serverId, "project", projectIconParams),
                            issueTypeIcons: issueTypeIcons
                        };
                        imagesCache[getCacheKey(serverId, project.id)] = projectImagesCache;
                    });
                    servers[serverId].projects = data;
                }
            }
        );

        return xhrProject;
    }

    function getIssueTypes(serverId, projectId) {
        var project = _.find(getProjects(serverId), function(project) {
            return project.id === projectId;
        });
        return project ? project.issueTypes : [];
    }

    function getServerById(serverId) {
        return servers[serverId] ? servers[serverId] : {};
    }

    function getProjects(serverId) {
        return (servers[serverId] && servers[serverId].projects) ? servers[serverId].projects : [];
    }

    function clearProjects(serverId) {
        servers[serverId] && delete servers[serverId].projects;
    }

    function getProjectIconUrl(serverId, projectId) {
        var cacheKey = getCacheKey(serverId, projectId);
        return imagesCache[cacheKey] ? imagesCache[cacheKey].iconUrl : "";
    }

    function getIssueTypeIconUrl(serverId, projectId, issueTypeId) {
        var cacheKey = getCacheKey(serverId, projectId);
        var cache = imagesCache[cacheKey];
        return (cache && cache.issueTypeIcons[issueTypeId]) ? cache.issueTypeIcons[issueTypeId] : "";
    }

    function getCacheKey(serverId, projectId) {
        return serverId + '-' + projectId;
    }

    return {
        loadServers: loadServers,
        loadProjects: loadProjects,
        getProjects: getProjects,
        getIssueTypes: getIssueTypes,
        getServerById: getServerById,
        getProjectIconUrl: getProjectIconUrl,
        getIssueTypeIconUrl: getIssueTypeIconUrl,
        clearProjects: clearProjects
    };
});
