(function($){
    "use strict";

    AJS.$(function ($) {
        $("#qunit-fixture").append("<div id='test-dateutil'>");
    });

    var DateUtil,
        options = {
            setup: function () {
                AJS.Meta.set("date.format", "dd MMM, yyyy");
                AJS.Meta.set("user-date-pattern", "dd MMM, yyyy");
                DateUtil = Confluence.InlineTasks.DateUtil;
                window.tinymce = {};
                window.tinymce.isIE = false;
            },
            teardown: function() {
                window.tinymce = null;
            }
        };

    AJS.test.require("com.atlassian.confluence.plugins.confluence-inline-tasks:date-helper-js-resources", AJS.$.noop);

    module("Confluence.InlineTasks.DateUtil", options);

    test("test 'parse' method work correctly", function() {
        ok(!!DateUtil);

        var date = DateUtil.parse("20-12-2014", "DD-MM-YYYY");

        ok(!!date);
        ok(date.get("year") === 2014);
        ok(date.get("month") === 12-1);
        ok(date.get("date") === 20);

        var date = DateUtil.parse("--12-dadasdsa", "DD-MM-YYYY");

        ok(!date);
    });

    test("test 'convertDateIntoHtml' method work correctly", function() {
        var date = DateUtil.parse("20-12-2014", "DD-MM-YYYY");
        var html = DateUtil.convertDateIntoHtml(date, "<time>", "test", "DD MMM, YYYY");

        var $testDate = $(html);

        equal($testDate.text(), "20 Dec, 2014");
        equal($testDate.attr("datetime"), "2014-12-20");
        equal($testDate.attr("class"), "test");
        equal($testDate.prop("tagName"), "TIME");


        date = DateUtil.parse("21-01-2015", "DD-MM-YYYY");
        html = DateUtil.convertDateIntoHtml(date, "<span>", "test", "DD MMM, YYYY");

        $testDate = $(html);

        equal($testDate.text(), "21 Jan, 2015");
        equal($testDate.attr("class"), "test");
        equal($testDate.prop("tagName"), "SPAN");
    });

}(AJS.$));