(function ($) {
    var pluginKey = "com.atlassian.confluence.plugins.confluence-jira-metadata";
    var featureDiscoveryId = 'inline-tasks-flag';

    function showFeatureDiscoveryHelpTip() {
        if (!!AJS.HelpTip) { // Check that the help tips plugin is available.
            var helpTipInfo = {
                id: null,
                body: Confluence.InlineTasks.Report.Templates.tasksFeatureDiscoveryNotification(),
                anchor: $("#user-menu-link")
            };
            var newHelpTip = new AJS.HelpTip(helpTipInfo);
            AJS.trigger('analyticsEvent', {name: 'confluence-spaces.tasks.feature.discovery.shown'});
            newHelpTip.show();
            Confluence.FeatureDiscovery.forPlugin(pluginKey).markDiscovered(featureDiscoveryId);
        }
    }

    $(function() {
        if ($("meta[name=show-task-feature-discovery-flag]").length > 0 &&
                Confluence.FeatureDiscovery.forPlugin(pluginKey).shouldShow(featureDiscoveryId)) {
            showFeatureDiscoveryHelpTip();
        }
    });

})(AJS.$);
