AJS.$(function ($) {
    "use strict";

    var templates = Confluence.InlineTasks.MyTasks.Templates,
        TasksTableSortable = Confluence.InlineTasks.TasksTableSortable,
        URL_REST_PAGINATION = "/rest/inlinetasks/1/my-task-report/",
        $wrapper = $(".table-wrapper"),
        $taskContainer = $wrapper.find('#task-container'),
        $spinner = $('.button-spinner'),
        $blanket = $wrapper.find('.task-blanket'),
        pageSize = 25,
        pageLimit = 7,
        columns = [],
        xhr;

    var labelMap = {
        'description': AJS.I18n.getText("inline-tasks.mytasks.column.desc"),
        'duedate': AJS.I18n.getText("inline-tasks.mytasks.column.duedate"),
        'location': AJS.I18n.getText("inline-tasks.mytasks.column.appearson"),
        'assignee': AJS.I18n.getText("inline-tasks.mytasks.column.assignee"),
        'completedate': AJS.I18n.getText("inline-tasks.mytasks.column.completed"),
        'blank.assignedToMe-complete.title': AJS.I18n.getText("inline-tasks.mytasks.blank.assigned.complete.title"),
        'blank.assignedToMe-complete.desc': AJS.I18n.getText("inline-tasks.mytasks.blank.assigned.complete.desc"),
        'blank.assignedToMe-incomplete.title': AJS.I18n.getText("inline-tasks.mytasks.blank.assigned.incomplete.title"),
        'blank.assignedToMe-incomplete.desc': AJS.I18n.getText("inline-tasks.mytasks.blank.assigned.incomplete.desc"),
        'blank.createdByMe-complete.title': AJS.I18n.getText("inline-tasks.mytasks.blank.created.complete.title"),
        'blank.createdByMe-complete.desc': AJS.I18n.getText("inline-tasks.mytasks.blank.created.complete.desc"),
        'blank.createdByMe-incomplete.title': AJS.I18n.getText("inline-tasks.mytasks.blank.created.incomplete.title"),
        'blank.createdByMe-incomplete.desc': AJS.I18n.getText("inline-tasks.mytasks.blank.created.incomplete.desc")
    };

    var columnMap = {
        assignedToMe: {
            incomplete: ['description', 'duedate', 'location'],
            complete: ['description', 'completedate', 'location']
        },
        createdByMe: {
            incomplete: ['description', 'assignee', 'duedate', 'location'],
            complete: ['description', 'assignee', 'completedate', 'location']
        }
    };

    //check if user came from email for analytics purposes
    var url = window.location.href;
    var regEx = /.*\bsource=email\b/;
    if (regEx.test(url)) {
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.tasks.my_tasks.clicked', data: {source: "email"}});
    }

    //helper function for disabling buttons
    var disableButtons = function(selector, status) {
        $(selector).attr("aria-disabled", status);
        $(selector).prop("disabled", status);
    };

    AJS.bind("inline-tasks.status-update.start", function(e, data){
        if (data.taskListQueue.length > 0) {
            disableButtons("#mytask-controls button.aui-button", true);
            disableButtons(".macro-auto-pagination", true);
            $(".macro-auto-pagination li a").on("click.mytasks.pagination", function(e) {
                e.preventDefault();
                e.stopPropagation();
            });
            $spinner.spin();
        }
    });

    AJS.bind("inline-tasks.status-update.complete", function(e, data) {
        if (data.taskListQueue.length === 0) {
            disableButtons("#mytask-controls button.aui-button", false);
            disableButtons(".macro-auto-pagination", false);
            $(".macro-auto-pagination li a").off("click.mytasks.pagination");
            $spinner.spinStop();
        }
    });

    $("#mytask-controls .aui-buttons").on("click", 'button', function (e) {
        var $target = $(e.target);
        $target.siblings('button[aria-pressed=true]').attr('aria-pressed', false);
        $target.attr('aria-pressed', true);
        var selectorData = {
            "taskCategory": $('#task-category button[aria-pressed=true]').attr("data-task-category"),
            "statusCategory": $('#task-status button[aria-pressed=true]').attr("data-task-status")
        };

        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.tasks.my_tasks.filtered', data: selectorData});

        //set selected tabs to url hash to reload selected tab when refresh page
        var hash = selectorData.taskCategory + "," + selectorData.statusCategory;
        window.location.hash = hash;

        //call render table manually if browser does not support addEventListener method(IE8 and below)
        if (!window.addEventListener) {
            renderTable();
        }
    });

    var renderTable = function () {
        xhr && xhr.abort(); //abort the ajax request if previous has not completed yet

        var category = $('#task-category button[aria-pressed=true]').attr("data-task-category");
        var status = $('#task-status button[aria-pressed=true]').attr("data-task-status");

        var columnsMappings = _.map(columnMap[category][status], function (key) {
            return {
                key: key,
                label: labelMap[key]
            };
        });

        if (!columnsMappings) {
            return;
        }

        $wrapper.attr("data-loading", true); // for testability
        $spinner.spin();
        $blanket.show();

        var currentUser = $("meta[name=ajs-remote-user]").attr('content');

        var creator, assignee;
        if (category === 'createdByMe') {
            creator = currentUser;
        } else if (category === 'assignedToMe') {
            assignee = currentUser;
        }

        columns = _.pluck(columnsMappings, 'key');

        var initialReportParameters = {
            columns: columns,
            assignees: [assignee],
            creators: [creator],
            status: status,
            sortColumn: "duedate",
            reverseSort: false
        };

        xhr = $.getJSON(Confluence.getContextPath() + URL_REST_PAGINATION, {
                'pageSize': pageSize,
                'pageIndex': 0,
                'reportParameters': JSON.stringify(initialReportParameters)
        }).done(function (data) {
                if (!(data.detailLines && data.detailLines.length)) {
                    //blank experience
                    $('#task-container, .aui-nav-pagination').empty();
                    return Confluence.InlineTasks.MyTasks.renderBlankExperiences(category, status, $taskContainer, labelMap);
                }

                var lineData = _.map(data.detailLines, function(line){
                    return {'task': line};
                });

                var renderedTable = templates.mytasksTable({
                    'columnsMappings': columnsMappings,
                    'lineData': lineData,
                    'columns': columns
                });

                $taskContainer.html(renderedTable);

                var $table = $taskContainer.find('table.mytasks');

                var tasksTableSortable = new TasksTableSortable({
                    $wrapper: $wrapper,
                    table: $table[0],
                    reportParametersDefault: initialReportParameters,
                    templates: Confluence.InlineTasks.Report.Templates,
                    analyticEventKey: "confluence-spaces.tasks.my_tasks.sorted",
                    restUrlPagination: URL_REST_PAGINATION,
                    ajaxUrl: Confluence.getContextPath() + URL_REST_PAGINATION,

                    pageIndex: 0,
                    pageSize: pageSize,
                    pageLimit: pageLimit,
                    pageTotal: data.totalPages,
                    adaptive: data.adaptive,
                    columns: columns,

                    onRenderEmptyTable: function () {
                        Confluence.InlineTasks.MyTasks.renderBlankExperiences(category, status, $taskContainer, labelMap);
                    },
                    onBusySorting: function (isBusy) {
                        if (isBusy) {
                            $spinner.spin();
                        }
                        else {
                            $spinner.spinStop();
                        }

                    }
                });

                tasksTableSortable.init();
                tasksTableSortable.renderPagination($taskContainer);
        }).always(function () {
                $wrapper.attr("data-loading", false); // for testability
                $spinner.spinStop();
                $blanket.hide();
        });
    };

    //load my task's selected tabs from url hash location
    var loadSelectedTabs = function () {
        var hash = window.location.hash || "assignedToMe,incomplete",
            createdByMe = hash.indexOf("createdByMe") > -1,
            complete = (hash.indexOf("complete") > -1 && hash.indexOf("incomplete") == -1);

        var $categoryButtons = $("#task-category button[data-task-category]");
        $categoryButtons.filter("[data-task-category='createdByMe']").attr('aria-pressed', createdByMe);
        $categoryButtons.filter("[data-task-category='assignedToMe']").attr('aria-pressed', !createdByMe);

        var $statusButtons = $("#task-status button[data-task-status]");
        $statusButtons.filter("[data-task-status='complete']").attr('aria-pressed', complete);
        $statusButtons.filter("[data-task-status='incomplete']").attr('aria-pressed', !complete);
    };

    //first time render analytics
    var selectorData = {
            "taskCategory": $('#task-category button[aria-pressed=true]').attr("data-task-category"),
            "statusCategory": $('#task-status button[aria-pressed=true]').attr("data-task-status")
        };
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.tasks.my_tasks.filtered', data: selectorData});

    Confluence.Blueprint.Selector.registerSelector(function(params) {
        if (params.fromMyTasks) {
            return "com.atlassian.confluence.plugins.confluence-inline-tasks:task-report-blueprint-item";
        }
    });

    $("#task-summary-link").on("click", function (e) {
        Confluence.Blueprint.loadDialog({
            initContext: {
                fromMyTasks: true
            }
        });
        e.preventDefault();
    });

    var refresh = function () {
        loadSelectedTabs();
        renderTable();
    };

    //when we change tabs(category, status) -> we update hash on url -> listen to that event and re-render table
    if(window.addEventListener) {
        window.addEventListener("hashchange", refresh);
    }

    refresh();

});