(function ($) {
    /* This is very dependant on the images used and the padding, etc */
    function isInCheckArea(e) {
        var offsetX, offsetY;

        // offsetX and offsetY are non-standard
        if (e.offsetX === undefined) {
            var offsetLeft = 0,
                offsetTop = 0,
                el = e.target,
                container;

            do {
                if (el.scrollTop != 0 || el.scrollLeft != 0) {
                    container = el;
                }
                offsetLeft += el.offsetLeft;
                offsetTop += el.offsetTop;

                el = el.offsetParent;
            }
            while (el && el != el.offsetParent); // el.offsetParent shouldn't ever return self, but it doesn't
                                                 // cost us much to have a second guard against infinite looping

            offsetX = e.pageX + (container ? container.scrollLeft : 0) - offsetLeft;
            offsetY = e.pageY + (container ? container.scrollTop : 0) - offsetTop;
        } else {
            offsetX = e.offsetX;
            offsetY = e.offsetY;
        }

        return offsetX >= 3 && offsetX <= 14 && offsetY >= 3 && offsetY <= 14;
    }

    // Ignores the bubbled event on any parent inline tasks
    function isActualTarget(e) {
        return e.currentTarget === e.target;
    }

    /* Determines the location of the element - returns a string
      specifying where it is in a task, task report, my tasks page or just the page.
      Used for analytics only. */
    function findContext($el) {
        var context = 'page';

        if ($el.closest("table.tasks-report").length) {
            context = 'report';
        } else if ($el.closest("#task-container").length) {
            context = 'mytasks';
        } else if ($el.closest("ul.inline-task-list").length) {
            context = 'task';
        }

        return context;
    }

    /* Given a task li element, searches using a particular selector for the first element
      that matches that selector. Will not return matching selectors in nested tasks. Returns
      an empty jquery object if no matches are found. */
    function findElementInTask($task, selector) {
        var thisId = $task.attr("data-inline-task-id");
        var selectedItem = $task.find(selector).first();
        if (selectedItem.closest("li").attr("data-inline-task-id") === thisId) {
            return selectedItem;
        } else {
            return $();
        }
    }

    function formatDate(date) {
        var year = '' + date.getFullYear();
        var month = '' + (date.getMonth() + 1);
        var day = '' + date.getDate();

        if (month.length < 2) {
            month = '0' + month;
        }

        if (day.length < 2) {
            day = '0' + day;
        }

        return [year, month, day].join('-');
    }

    var pageUnloading = false;

    $(window).bind('beforeunload', function(){
        pageUnloading = true;
    });

    var taskListQueue = [];
    $(document).delegate('ul.inline-task-list > li[data-inline-task-id]', {
        'click' : function(e) {

            if (isActualTarget(e) && isInCheckArea(e)) {
                var $el = $(e.target).toggleClass('checked'),
                    status = $el.hasClass('checked') ? "CHECKED" : "UNCHECKED",
                    taskId = $el.data("inline-task-id"),
                    contentId = $el.closest('ul').attr('data-inline-tasks-content-id') || AJS.params.pageId,
                    url = AJS.contextPath() + "/rest/inlinetasks/1/task/" + contentId + "/" + taskId + "/";


                $el.prop("disabled", true);
                var $parent = $el.closest('tr');
                $parent.attr("aria-disabled", true);
                taskListQueue.push(taskId);
                AJS.trigger("inline-tasks.status-update.start", { status: status, taskId: taskId, taskListQueue: taskListQueue });


                $.ajax({
                    type: 'POST',
                    url: url,
                    data: $.toJSON({
                       status: status,
                       trigger: 'VIEW_PAGE'
                    }),
                    dataType: 'json',
                    contentType: 'application/json',
                    timeout: 30000,
                    error: function(jqXHR, statusText, error) {
                        if (pageUnloading || statusText === 'timeout') {
                            // CONFDEV-10030 - it's likely that the request still completes successfully despite a timeout,
                            // or when the user navigates away from the page. So we suppress the error in both of these cases.
                            return;
                        }
                        AJS.logError("Inline Task #" + taskId + " was not persisted to " + status + " because of " + error + " (status: " + statusText + ")");
                        $el.toggleClass('checked');

                        var notice;
                        if (jqXHR.status === 403) {
                            notice = new Confluence.InlineTasks.Notice({
                                textMessage: AJS.I18n.getText("inline-tasks.notice.forbidden"),
                                className: "forbidden-notice"
                            });
                        }
                        else{
                            notice = new Confluence.InlineTasks.Notice();
                        }
                        notice.show();
                    },
                    success: function() {
                        var data =  {
                            dueDate: findElementInTask($el, "time").attr("datetime"),
                            completionDate: formatDate(new Date()),
                            mode: 'view',
                            assigneeUsername: findElementInTask($el, ".user-mention").attr('data-username'),
                            context: findContext($el)
                        };

                        if (status === "CHECKED") {
                            AJS.trigger('analyticsEvent', {name: 'confluence-spaces.tasks.completed', data: data});
                        }
                    }
                }).always(function() {
                    $el.prop("disabled", false);
                    var $parent = $el.closest('tr');
                    $parent.attr("aria-disabled", false);
                    //IE<9 do not support Array.prototype.indexOf, so not use it
                    taskListQueue.splice(AJS.indexOf(taskListQueue, taskId), 1);
                    AJS.trigger("inline-tasks.status-update.complete", { status: status, taskId: taskId, taskListQueue: taskListQueue });

                });
            }
        },
        'mousemove' : function(e) {
            if (isActualTarget(e)) {
                if (isInCheckArea(e)) {
                    $(e.target).addClass('hover');
                } else {
                    $(e.target).removeClass('hover');
                }
            }
        },
        'mouseout' : function(e) {
            if (isActualTarget(e)) {
                $(e.target).removeClass('hover');
            }
        },
        'mousedown' : function(e) {
            if (isActualTarget(e) && isInCheckArea(e)) {
                $(e.target).addClass('task-active');
            }
        },
        'mouseup' : function(e) {
            if (isActualTarget(e) && isInCheckArea(e)) {
                $(e.target).removeClass('task-active');
            }
        }
    });

    $('ul.inline-task-list li:not(.checked) time.date-upcoming').tooltip({
        title: function() {
            return AJS.I18n.getText("inline-tasks.date.duesoon");
        },
        live: true
    });

    $('ul.inline-task-list li:not(.checked) time.date-past').tooltip({
        title: function() {
            return AJS.I18n.getText("inline-tasks.date.overdue")
        },
        live: true
    });

    $("span.emptycompletedate").tooltip({
        title: function () {
            return AJS.I18n.getText("com.atlassian.confluence.plugins.confluence-inline-tasks.tasks-report.no.complete.date.tooltip");
        },
        live: true
    });

    $(document).on("click", "time", function() {
        var $this = $(this);

        // Fire an analytics event when a date lozenge is clicked.
        var data = {date: $this.attr("datetime"), mode: "view", context: findContext($this)};
        AJS.trigger('analyticsEvent', {name: 'confluence-spaces.date.clicked', data: data});
    });
})(AJS.$);
