/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.transformer.InlineTaskFinder;
import com.atlassian.confluence.plugins.tasklist.upgradetask.InterruptingUncaughtExceptionHandler;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationLatch;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationPageFinder;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationTaskExtractor;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationTaskInserter;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoUpgradeTaskCompletedEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageToAoMigrationUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(StorageToAoMigrationUpgradeTask.class);
    private static final long LOG_FREQUENCY = TimeUnit.SECONDS.toMillis(10L);
    private static final String HIBERNATE_DATASOURCE_CONFIG_KEY = "hibernate.connection.datasource";
    private static final String HIBERNATE_POOL_SIZE_CONFIG_KEY = "hibernate.c3p0.max_size";
    private static final String NUM_THREADS_OVERRIDE_PROPERTY = "tasklist.storagetoaoupgradetask.numthreads";
    private static final int DBCP_DEFAULT_POOL_SIZE = 8;
    private static volatile boolean isUpgrading = false;
    private final PageManager pageManager;
    private final InlineTaskFinder inlineTaskFinder;
    private final InlineTaskService inlineTaskService;
    private final EventPublisher eventPublisher;
    private final TransactionTemplate transactionTemplate;
    private final PluginHibernateSessionFactory hibernateSessionFactory;
    private final BootstrapManager bootstrapManager;
    private final ActiveObjects activeObjects;
    private long startTime;
    private long lastLogTime = System.currentTimeMillis();
    private int lastLogCount = -1;

    @Autowired
    public StorageToAoMigrationUpgradeTask(PageManager pageManager, InlineTaskFinder inlineTaskFinder, InlineTaskService inlineTaskService, EventPublisher eventPublisher, TransactionTemplate transactionTemplate, PluginHibernateSessionFactory hibernateSessionFactory, BootstrapManager bootstrapManager, ActiveObjects activeObjects) {
        this.pageManager = pageManager;
        this.inlineTaskFinder = inlineTaskFinder;
        this.inlineTaskService = inlineTaskService;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.hibernateSessionFactory = hibernateSessionFactory;
        this.bootstrapManager = bootstrapManager;
        this.activeObjects = activeObjects;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Goes through all Confluence content with tasks and pulls task information out into an AO table.";
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-inline-tasks";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.prepareUpgrade();
        LinkedBlockingQueue<ContentEntityObject> pageQueue = new LinkedBlockingQueue<ContentEntityObject>(100);
        LinkedBlockingQueue<Task> tasksMigrationQueue = new LinkedBlockingQueue<Task>(500);
        AtomicInteger migratedTaskCounter = new AtomicInteger(0);
        int numThreads = Math.min(Math.min(10, this.getIdealNumberOfThreads()), this.getDbConnectionPoolSize() - 2);
        int maxThreads = (Integer)this.getNumThreadsOverride().getOrElse((Object)numThreads);
        int numThreadsRemaining = maxThreads - 1 - 1;
        int numTaskExtractionThreads = Math.max(1, numThreadsRemaining / 2);
        int numTaskInsertionThreads = Math.max(1, numThreadsRemaining -= numTaskExtractionThreads);
        StorageToAoMigrationLatch migrationLatch = new StorageToAoMigrationLatch(numTaskExtractionThreads, numTaskInsertionThreads);
        ArrayList upgradeTaskThreads = Lists.newArrayList();
        upgradeTaskThreads.add(this.buildPageFinderThread(migrationLatch, pageQueue));
        upgradeTaskThreads.addAll(this.buildTaskExtractionThreads(numTaskExtractionThreads, migrationLatch, pageQueue, tasksMigrationQueue));
        upgradeTaskThreads.addAll(this.buildTaskInsertionThreads(numTaskInsertionThreads, migrationLatch, tasksMigrationQueue, migratedTaskCounter));
        this.startThreads(upgradeTaskThreads);
        try {
            while (!migrationLatch.await(100L, TimeUnit.MILLISECONDS)) {
                this.logProgress(migratedTaskCounter.get());
            }
            this.finishUpgradeSuccessfully(migratedTaskCounter.get());
        }
        catch (InterruptedException e) {
            log.error("Inline task migration failed! {} tasks were migrated. You may try rerunning it or contactAtlassian support if it continues to fail.", (Object)migratedTaskCounter.get());
            throw e;
        }
        finally {
            this.postUpgrade(upgradeTaskThreads);
        }
        return Collections.emptyList();
    }

    public static boolean isUpgrading() {
        return isUpgrading;
    }

    private int getIdealNumberOfThreads() {
        return Runtime.getRuntime().availableProcessors() * 2 + 2;
    }

    private static void setIsUpgrading(boolean isUpgrading) {
        StorageToAoMigrationUpgradeTask.isUpgrading = isUpgrading;
    }

    private void postUpgrade(Collection<Thread> upgradeTaskThreads) throws InterruptedException {
        for (Thread upgradeTaskThread : upgradeTaskThreads) {
            upgradeTaskThread.join();
        }
        StorageToAoMigrationUpgradeTask.setIsUpgrading(false);
    }

    private void startThreads(Collection<Thread> upgradeTaskThreads) {
        Thread parentThread = Thread.currentThread();
        ImmutableList.Builder threads = ImmutableList.builder();
        threads.addAll(upgradeTaskThreads);
        threads.add((Object)parentThread);
        InterruptingUncaughtExceptionHandler uncaughtExceptionHandler = new InterruptingUncaughtExceptionHandler((Collection<Thread>)threads.build());
        for (Thread upgradeTaskThread : upgradeTaskThreads) {
            upgradeTaskThread.start();
            upgradeTaskThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
    }

    private Thread buildPageFinderThread(StorageToAoMigrationLatch countDownLatch, BlockingQueue<ContentEntityObject> pageQueue) {
        return new Thread((Runnable)new StorageToAoMigrationPageFinder(pageQueue, this.pageManager, this.transactionTemplate, countDownLatch, this.activeObjects), this.getClass().getSimpleName() + "-PageFinder");
    }

    private Collection<Thread> buildTaskExtractionThreads(int numTaskExtractionThreads, StorageToAoMigrationLatch countDownLatch, BlockingQueue<ContentEntityObject> pageQueue, BlockingQueue<Task> tasksMigrationQueue) {
        ImmutableList.Builder taskExtractorThreadListBuilder = ImmutableList.builder();
        log.info("Using {} task extraction threads", (Object)numTaskExtractionThreads);
        boolean checkForDuplicates = this.inlineTaskService.countAllTasks() > 0L;
        for (int i = 1; i <= numTaskExtractionThreads; ++i) {
            Thread taskExtractionThread = new Thread((Runnable)new StorageToAoMigrationTaskExtractor(pageQueue, tasksMigrationQueue, this.inlineTaskFinder, this.inlineTaskService, this.transactionTemplate, this.hibernateSessionFactory, this.pageManager, checkForDuplicates, countDownLatch), this.getClass().getSimpleName() + "-TaskExtractor-" + i);
            taskExtractorThreadListBuilder.add((Object)taskExtractionThread);
        }
        return taskExtractorThreadListBuilder.build();
    }

    private Collection<Thread> buildTaskInsertionThreads(int numTaskInsertionThreads, StorageToAoMigrationLatch countDownLatch, BlockingQueue<Task> tasksMigrationQueue, AtomicInteger migratedTaskCounter) {
        ImmutableList.Builder taskExtractorThreadListBuilder = ImmutableList.builder();
        log.info("Using {} task insertion threads", (Object)numTaskInsertionThreads);
        for (int i = 1; i <= numTaskInsertionThreads; ++i) {
            Thread taskExtractionThread = new Thread((Runnable)new StorageToAoMigrationTaskInserter(this.transactionTemplate, tasksMigrationQueue, this.inlineTaskService, migratedTaskCounter, countDownLatch), this.getClass().getSimpleName() + "-TaskInserter-" + i);
            taskExtractorThreadListBuilder.add((Object)taskExtractionThread);
        }
        return taskExtractorThreadListBuilder.build();
    }

    private void logProgress(int migratedTaskCount) {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastLog = currentTime - this.lastLogTime;
        if (migratedTaskCount == this.lastLogCount || timeSinceLastLog < LOG_FREQUENCY) {
            return;
        }
        log.info("Migrating tasks to active objects. {} tasks migrated so far.", (Object)migratedTaskCount);
        this.lastLogTime = currentTime;
        this.lastLogCount = migratedTaskCount;
    }

    private void prepareUpgrade() {
        this.startTime = System.currentTimeMillis();
        StorageToAoMigrationUpgradeTask.setIsUpgrading(true);
    }

    private void finishUpgradeSuccessfully(int migratedTaskCount) {
        long timeTaken = System.currentTimeMillis() - this.startTime;
        log.info("Successfully migrated {} tasks in {}ms.", (Object)migratedTaskCount, (Object)timeTaken);
        this.eventPublisher.publish((Object)new StorageToAoUpgradeTaskCompletedEvent(migratedTaskCount, timeTaken));
    }

    private int getDbConnectionPoolSize() {
        Properties hibernateProperties = this.bootstrapManager.getHibernateProperties();
        return this.isDbcpManagedConnectionPool(hibernateProperties) ? this.getDbcpConnectionPoolSize() : this.getC3p0ConnectionPoolSize(hibernateProperties);
    }

    private boolean isDbcpManagedConnectionPool(Properties hibernateProperties) {
        return StringUtils.isNotEmpty((CharSequence)hibernateProperties.getProperty(HIBERNATE_DATASOURCE_CONFIG_KEY));
    }

    private int getC3p0ConnectionPoolSize(Properties hibernateProperties) {
        String poolSize = hibernateProperties.getProperty(HIBERNATE_POOL_SIZE_CONFIG_KEY);
        return Integer.parseInt(poolSize);
    }

    private int getDbcpConnectionPoolSize() {
        log.warn("Unable to determine database connection pool size. Assuming the default DBCP pool size, which may cause the upgrade task run a little slower. You may set the {} system property to a higher value like {} if you are sure you have enough database connections to make it run faster.", new Object[]{NUM_THREADS_OVERRIDE_PROPERTY, this.getIdealNumberOfThreads()});
        return 8;
    }

    private Maybe<Integer> getNumThreadsOverride() {
        String maxThreads = System.getProperty(NUM_THREADS_OVERRIDE_PROPERTY);
        try {
            if (maxThreads != null) {
                return Option.some((Object)Integer.parseInt(maxThreads));
            }
        }
        catch (NumberFormatException e) {
            log.warn("Your configured value for {} was invalid: {}", (Object)NUM_THREADS_OVERRIDE_PROPERTY, (Object)maxThreads);
        }
        return Option.none();
    }

    static {
        LogManager.getLogger(StorageToAoMigrationUpgradeTask.class).setLevel(Level.INFO);
    }
}

