AJS.$(function($) {
    "use strict";

    var URL_REST_PAGINATION = "/rest/inlinetasks/1/task-report/",
        templates = Confluence.InlineTasks.Report.Templates,
        TasksTableSortable = Confluence.InlineTasks.TasksTableSortable;

    var $wrapperOfTasksReportMacro = $(".tasks-report").parent();
    _.each($wrapperOfTasksReportMacro, function(obj) {
        var $this = $(obj),
                $table = $this.find('table.tasks-report'),
                pageSize = $table.data('page-size'),
                totalPages = $table.data('total-pages'),
                pageLimit = $table.data('page-limit'),
                adaptive = $table.data('adaptive'),
                searchString = $this.find("input[name=reportParameters]").val(),
                reportParameters = JSON.parse(searchString);

        //helper function for disabling buttons
        var disableButtons = function(selector, status) {
            $(selector).attr("aria-disabled", status);
        };

        AJS.bind("inline-tasks.status-update.start", function(e, data) {
            if (data.taskListQueue.length > 0) {
                var $element = $('li[data-inline-task-id=' + data.taskId + ']').closest('.tasks-report').siblings('.macro-auto-pagination');
                disableButtons($element, true);
                $element = $element.find("li a");
                $element.on("click.taskreport.pagination", function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                });
            }
        });

        AJS.bind("inline-tasks.status-update.complete", function(e, data) {
            if (data.taskListQueue.length === 0) {
                disableButtons(".macro-auto-pagination", false);
                $(".macro-auto-pagination li a").off("click.taskreport.pagination");
            }
        });

        var $wrapper = $table.closest(".table-wrapper");
        var tasksTableSortable  = new TasksTableSortable({
            $wrapper: $wrapper,
            table: $table[0],
            sortReverseSortDefault: reportParameters.reverseSort,
            sortColumnDefault: TasksTableSortable.getColumnNameFromSortBy(reportParameters.sortColumn),
            reportParametersDefault: reportParameters,
            pageIndex: 0,
            pageSize: pageSize,
            pageTotal: totalPages,
            adaptive: adaptive,
            pageLimit: pageLimit,
            templates: templates,
            columns: reportParameters.columns,
            onRenderEmptyTable: function () {
                Confluence.InlineTasks.TasksReport.renderBlankExperiences($wrapper, reportParameters.status);
            },
            analyticEventKey: "confluence-spaces.tasks.report.sorted",
            restUrlPagination: URL_REST_PAGINATION,
            ajaxUrl: Confluence.getContextPath() + URL_REST_PAGINATION
        });
        tasksTableSortable.init();
        if (adaptive || totalPages > 1) {
            tasksTableSortable.renderPagination();
        }
    });
});
