$(function ($) {
    'use strict';

    /* This is very dependant on the images used and the padding, etc */
    function isInCheckArea(e, inTable) {
        var offsetX, offsetY;

        // Browsers are all over the place for mouse events. :/
        if ($.browser.mozilla) {
            offsetX = e.pageX - e.target.offsetLeft;
            offsetY = e.pageY - e.target.offsetTop;
        } else {
            offsetX = e.offsetX;
            offsetY = e.offsetY;
        }

        if (inTable) {
            return offsetX >= 3 && offsetX <= 14 && offsetY >= 3 && offsetY <= 14;
        } else {
            return offsetX >= 3 && offsetX <= 14 && offsetY >= 6 && offsetY <= 17;
        }

    }

    // Ignores the bubbled event on any parent inline tasks
    function isActualTarget(e) {
        return e.currentTarget === e.target;
    }

    function isInTable(e) {
        return $(e.target).closest("table.confluenceTable").size() > 0;
    }

    function getRestUrl(contentId, taskId) {
        return ConfluenceMobile.AppData.get('confluence-context-path') + '/rest/inlinetasks/1/task/' + contentId + '/' + taskId + '/';
    }

    $('.container').delegate('ul.inline-task-list > li[data-inline-task-id]', 'click', function (e) {
        if (isActualTarget(e) && isInCheckArea(e, isInTable(e))) {
            var $el = $(this).toggleClass('checked'),
                status = $el.hasClass('checked') ? 'CHECKED' : 'UNCHECKED',
                taskId = $el.data('inline-task-id'),
                contentId = $el.closest('ul').attr('data-inline-tasks-content-id') || $("div.content").data("content-id"),
                url = getRestUrl(contentId, taskId);

            var model = {
                status: status,
                trigger: 'VIEW_PAGE'
            };

            var onFailure = function(response, statusText) {
                if (statusText === 'timeout') {
                    // CONFDEV-10030 - it's likely that the request still completes successfully despite a timeout
                    return;
                }
                $el.toggleClass('checked');
                ConfluenceMobile.genericAjaxErrorHandler(response, model, {
                    message: AJS.I18n.getText("inline-tasks.notice.unavailable.mobile"),
                    onRetry: send
                });
            };

            $.ajax({
                type: 'POST',
                url: url,
                data: JSON.stringify(model),
                dataType: 'json',
                contentType: 'application/json',
                timeout: 30000,
                error: onFailure
            });
        }
    });
});
