/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptingUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(InterruptingUncaughtExceptionHandler.class);
    private final Collection<Thread> threads;

    public InterruptingUncaughtExceptionHandler(Collection<Thread> threads) {
        this.threads = threads;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error("Uncaught exception in thread " + t.getName() + ". Interrupting all threads.", e);
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
    }
}

