/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.importexport;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.inlinetask.InlineTaskListItem;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.transformer.InlineTaskFinder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InlineTasksRebuildImportFinishedListener {
    private static final Logger log = LoggerFactory.getLogger(InlineTasksRebuildImportFinishedListener.class);
    private static final int pagesBatchSize = 100;
    private static final String selectAllCurrentPageAndBlogPostIds = "select page.id from AbstractPage page where page.space.id = :spaceId and page.contentStatus = 'current'";
    private final InlineTaskFinder inlineTaskFinder;
    private final InlineTaskService inlineTaskService;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final PluginHibernateSessionFactory pluginSessionFactory;
    private final TransactionTemplate txTemplate;
    private final EventPublisher eventPublisher;

    @Autowired
    public InlineTasksRebuildImportFinishedListener(InlineTaskFinder inlineTaskFinder, InlineTaskService inlineTaskService, SpaceManager spaceManager, PageManager pageManager, PluginHibernateSessionFactory pluginSessionFactory, TransactionTemplate txTemplate, EventPublisher eventPublisher) {
        this.inlineTaskFinder = Objects.requireNonNull(inlineTaskFinder, "null inlineTaskFinder");
        this.inlineTaskService = Objects.requireNonNull(inlineTaskService, "null inlineTaskService");
        this.spaceManager = Objects.requireNonNull(spaceManager, "null spaceManager");
        this.pageManager = Objects.requireNonNull(pageManager, "null pageManager");
        this.pluginSessionFactory = Objects.requireNonNull(pluginSessionFactory, "null pluginSessionFactory");
        this.txTemplate = Objects.requireNonNull(txTemplate, "null txTemplate");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "null eventPublisher");
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void teardown() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onImportFinishedEvent(AsyncImportFinishedEvent event) {
        if (event.isSiteImport() || event.getImportContext() == null) {
            log.debug("Skipping execution, site import: {}, context null: {}", (Object)event.isSiteImport(), (Object)(event.getImportContext() == null ? 1 : 0));
            return;
        }
        this.txTemplate.execute(() -> {
            try {
                String spaceKey = event.getImportContext().getSpaceKeyOfSpaceImport();
                log.debug("Executing inline task rebuild process for space {}", (Object)spaceKey);
                Space space = this.spaceManager.getSpace(spaceKey);
                Session session = this.pluginSessionFactory.getSession();
                List pageBlogIds = session.createQuery(selectAllCurrentPageAndBlogPostIds).setParameter("spaceId", (Object)space.getId()).list();
                UnmodifiableIterator batches = Iterators.partition(pageBlogIds.iterator(), (int)100);
                log.debug("Total {} pages and blogs to process.", (Object)pageBlogIds.size());
                while (batches.hasNext()) {
                    this.pageManager.getAbstractPages((Iterable)batches.next()).forEach(page -> this.processContent((AbstractPage)page, this.inlineTaskFinder));
                    session.flush();
                    session.clear();
                }
            }
            catch (HibernateException e) {
                log.warn("Error while recreating inline tasks ", (Throwable)e);
            }
            return null;
        });
    }

    private void processContent(AbstractPage abstractPage, InlineTaskFinder finder) {
        long contentId = abstractPage.getId();
        Date pageLastModified = Optional.ofNullable(abstractPage.getLastModificationDate()).orElse(new Date());
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)abstractPage.toPageContext());
        Map<Long, InlineTaskListItem> tasks = finder.findTasksInContent(contentId, abstractPage.getBodyAsString(), (ConversionContext)conversionContext);
        log.trace("Processing {} tasks found in: {}", (Object)tasks.keySet().size(), (Object)abstractPage.getTitle());
        for (InlineTaskListItem newInlineTask : tasks.values()) {
            Task task = finder.parseTask(newInlineTask, contentId, (ConversionContext)conversionContext);
            Task newTask = new Task.Builder(task).withCreateDate(pageLastModified).withCompleteDate(newInlineTask.isCompleted() ? pageLastModified : null).build();
            this.inlineTaskService.create(newTask);
        }
    }
}

