define('confluence/ic/view/resolved-dialog-discovery',
    [
        'jquery',
        'underscore',
        'backbone',
        'ajs'
    ],
    function(
        $,
        _,
        Backbone,
        AJS
        ) {

        "use strict";

        var ResolvedDialogDiscoveryView = Backbone.View.extend({
            DIALOG_BACKGROUND_COLOR: '#ffffff',
            DIALOG_BORDER_COLOR: '#f79232',

            initialize: function() {
                _.bindAll(this, 'getDiscoveryDialogContent', 'destroy', 'onEndScroll');
            },

            template: Confluence.Templates.IC.resolvedDiscovery,

            show: function() {
                $.when(this.scrollTop()).done(this.onEndScroll);
            },

            onEndScroll: function() {
                this.showToolsMenu();
                this._discoveryDialog = this.createDiscoveryDialog();
                this._discoveryDialog.show();
            },

            showToolsMenu: function() {
                var $toolMenu = $('#action-menu');
                $toolMenu.on('aui-dropdown2-hide', this.destroy);

                // show the dropdown
                $('#action-menu-link').trigger('aui-button-invoke');

                // Remove current active item
                $toolMenu.find('a.active').removeClass('active');

                // Active Resolved Comment Item
                var item = $toolMenu.find('#view-resolved-comments').addClass('active');
                // focus need to be wrapped in setTimeout to avoid unexpected scrolling behaviour
                setTimeout(function() {
                    item.focus();
                });
            },

            createDiscoveryDialog: function() {
                var dialogOption = {
                    gravity: 'w', // As of AUI 5.5, Inline Dialog supported gravity property
                    hideCallback: this.destroy,
                    width: 280,
                    noBind: true
                };

                var inlineDialog = AJS.InlineDialog($('#view-resolved-comments'), 'ic-resolved-dialog-discovery', this.getDiscoveryDialogContent, dialogOption);

                // Prevent inline-dialog is hidden when click on content inside its
                inlineDialog.on('click focusin mousedown', function (e) {
                    e.stopPropagation();
                });

                return inlineDialog;
            },

            getDiscoveryDialogContent: function($content, trigger, showPopup) {
                var html = this.template();
                $content.html(html);

                var me = this;
                // bind event to buttons
                $content.find('#ic-resolved-discovery-dismiss').on('click', function() {
                    Backbone.trigger("ic:resolved:dismiss:recovery");
                    me._discoveryDialog.hide();
                });

                showPopup();
                return false;
            },

            scrollTop: function() {
                var $splitterContent = $('#splitter-content');
                var isDocTheme = !!$splitterContent.length;
                var $scrollContainer = (isDocTheme) ? $splitterContent : $('html, body');

                // Need to delay scroll 1 millisecond to allow click event to propagate before executing code
                var delay = ($scrollContainer.scrollTop() === 0) ? 1 : 300;
                return $scrollContainer.animate({ scrollTop: 0 }, delay);
            },

            destroy: function() {
                // when inline dialog is hidden, make sure its dropdown should also hidden
                var $toolMenu = $('#action-menu');
                $toolMenu.off('aui-dropdown2-hide');
                if ($toolMenu.is(':visible')) {
                    $('#action-menu-link').trigger('aui-button-invoke');
                }
                this._discoveryDialog.remove();
                this.remove();
            }
        });

        return ResolvedDialogDiscoveryView;
    });
