define('confluence/ic/analytics',
    [
        'ajs',
        'underscore',
        'backbone'
    ], function(
        AJS,
        _,
        Backbone
    ) {
    "use strict";

    var Analytics = {};
    _.extend(Analytics, Backbone.Events);

    Analytics.start = function() {
        if (this.running === true) {
            return;
        }
        this.running = true;

        this.send = function (name, properties) {
            AJS.trigger('analytics', {name: name, data: properties});
        };

        this.listenTo(Backbone, "ic:highlight-panel-click", function() {
            this.send('confluence.highlight.actions.comment.inline');
        });

        this.listenTo(Backbone, "ic:view", function(comment, source) {
            this.send('confluence.comment.inline.view');
            if (source === 'nav') {
                this.send('confluence.comment.inline.view.nav');
            }
            if (source === 'permalink') {
                this.send('confluence.comment.inline.view.permalink');
            }
        });

        this.listenTo(Backbone, "ic:overlap", function() {
            this.send('confluence.comment.inline.overlap');
        });

        this.listenTo(Backbone, "ic:edit", function() {
            this.send('confluence.comment.inline.edit');
        });

        this.listenTo(Backbone, "ic:persist", function() {
            this.send('confluence.comment.inline.create');
        });

        this.listenTo(Backbone, "ic:sidebar:close", function() {
            this.send('confluence.comment.inline.sidebar.close');
        });

        this.listenTo(Backbone, "ic:reply:persist", function() {
            this.send('confluence.comment.inline.reply');
        });

        this.listenTo(Backbone, "ic:delete ic:reply:delete", function() {
            this.send('confluence.comment.inline.delete');
        });

        this.listenTo(Backbone, "ic:resolved", function() {
            this.send('confluence.comment.inline.resolved');
        });

        this.listenTo(Backbone, "ic:unresolved", function() {
            this.send('confluence.comment.inline.unresolved');
        });

        this.listenTo(Backbone, "ic:resolved:view", function(totalResolvedComments) {
            var properties = {
                total: totalResolvedComments
            };
            this.send('confluence.comment.inline.resolved.view', properties);
        });

        this.listenTo(Backbone, "ic:resolved:dismiss:recovery", function() {
            this.send('confluence.comment.inline.resolved.dismiss');
        });

        this.listenTo(Backbone, "ic:resolved:show:recovery", function() {
            this.send('confluence.comment.inline.resolved.discovery');
        });

        this.listenTo(Backbone, "ic:open:dangled", function(comment) {
            var properties = {
                commentId: comment.get("id"),
                pageId: AJS.Meta.get('page-id')
            };
            this.send('confluence.comment.inline.open.dangled', properties);
        });
        this.listenTo(Backbone, "ic:editor:load:fail", function() {
            var properties = {
                pageId: AJS.Meta.get('page-id')
            };
            this.send('confluence.comment.inline.editor.load.fail', properties);
        });

        this.listenTo(Backbone, "ic:resolve:dangled:failed", function(comment) {
            var properties = {
                commentId: comment.get("id"),
                pageId: AJS.Meta.get('page-id')
            };
            this.send('confluence.comment.inline.resolved.dangled.failed', properties);
        });
    };

    Analytics.stop = function() {
        this.running = false;
        this.stopListening();
    };

    return Analytics;
});