/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ozymandias;

import com.atlassian.fugue.Option;
import com.atlassian.ozymandias.ThrowableLogger;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.util.concurrent.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SafeBeanInstantiator {
    private static final Logger log = LoggerFactory.getLogger(SafeBeanInstantiator.class);

    public static <T> Option<T> load(Class<T> beanClass, Plugin toInstantiateFrom) {
        Assertions.notNull((String)"beanClass is required", beanClass);
        Assertions.notNull((String)"toInstantiateFrom is required", (Object)toInstantiateFrom);
        log.debug("Attempting to instantiate a bean of type '{}' from plugin with key '{}'", beanClass, (Object)toInstantiateFrom.getKey());
        if (SafeBeanInstantiator.isNotContainerManagedPlugin(toInstantiateFrom)) {
            return Option.none();
        }
        try {
            return Option.some(SafeBeanInstantiator.loadBean(beanClass, toInstantiateFrom));
        }
        catch (Throwable t) {
            SafeBeanInstantiator.handleThrowable(t, String.format("Unable to instantiate a bean of type '%s' from plugin with key '%s' because of '%s - %s'.", beanClass, toInstantiateFrom.getKey(), ThrowableLogger.getClassName(t), t.getMessage()));
            return Option.none();
        }
    }

    public static <T> Option<T> load(String className, Class<T> expectedType, Class<?> callingClass, Plugin toInstantiateFrom) {
        Assertions.notNull((String)"beanClass is required", (Object)className);
        Assertions.notNull((String)"expectedType is required", expectedType);
        Assertions.notNull((String)"callingClass is required", callingClass);
        Assertions.notNull((String)"toInstantiateFrom is required", (Object)toInstantiateFrom);
        log.debug("Attempting to instantiate a bean with class name '" + className + "' with expected supertype '{}' from plugin with key '{}'", expectedType, (Object)toInstantiateFrom.getKey());
        if (SafeBeanInstantiator.isNotContainerManagedPlugin(toInstantiateFrom)) {
            return Option.none();
        }
        try {
            Class actualClass = toInstantiateFrom.loadClass(className, callingClass);
            T actualBean = SafeBeanInstantiator.loadBean(actualClass, toInstantiateFrom);
            if (!expectedType.isAssignableFrom(actualBean.getClass())) {
                log.warn("Instantiated bean of type '{}', but expected type was '{}'. Returning absent result.", actualBean.getClass(), expectedType);
                return Option.none();
            }
            return Option.some(actualBean);
        }
        catch (Throwable t) {
            SafeBeanInstantiator.handleThrowable(t, String.format("Unable to instantiate a bean with class name '%s' with expected supertype '%s' from plugin with key '%s' because of '%s - %s'.", className, expectedType, toInstantiateFrom.getKey(), ThrowableLogger.getClassName(t), t.getMessage()));
            return Option.none();
        }
    }

    private static boolean isNotContainerManagedPlugin(Plugin plugin) {
        boolean isNot;
        boolean bl = isNot = !(plugin instanceof ContainerManagedPlugin);
        if (isNot) {
            log.warn("Cannot instantiate bean for plugin with key '{}'. Plugin is not an instance of ContainerManagedPlugin", (Object)plugin.getKey());
        }
        return isNot;
    }

    private static <T> T loadBean(Class<T> beanClass, Plugin toLoadFrom) {
        return (T)((ContainerManagedPlugin)toLoadFrom).getContainerAccessor().createBean(beanClass);
    }

    private static void handleThrowable(Throwable toHandle, String errorMessage) {
        if (toHandle instanceof Error) {
            SafeBeanInstantiator.handleError((Error)toHandle, errorMessage);
        } else {
            ThrowableLogger.logThrowable(errorMessage, toHandle, log);
        }
    }

    private static void handleError(Error error, String errorMessage) {
        if (!(error instanceof LinkageError)) {
            throw error;
        }
        ThrowableLogger.logThrowable(ThrowableLogger.LINKAGE_ERROR_MESSAGE + " " + errorMessage, error, log);
    }
}

