/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.webpanel;

import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceWebPanelServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceWebPanelServlet.class);
    private static final String RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin:confluence-webpanel-resources";
    private static final String TEMPLATE_KEY = "Confluence.Templates.HipChat.SpaceToRoom.WebPanel.main";
    private final PredefinedSearchBuilder searchBuilder;
    private final SearchManager searchManager;
    private final TemplateRenderer templateRenderer;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ApplicationProperties applicationProperties;

    public ConfluenceWebPanelServlet(PredefinedSearchBuilder searchBuilder, SearchManager searchManager, TemplateRenderer templateRenderer, SoyTemplateRenderer soyTemplateRenderer, ApplicationProperties applicationProperties) {
        this.searchBuilder = searchBuilder;
        this.searchManager = searchManager;
        this.templateRenderer = templateRenderer;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.applicationProperties = applicationProperties;
    }

    private void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String relativeRequestPath = StringUtils.removeStart((String)(request.getRequestURI() + "?" + request.getQueryString()), (String)contextPath);
        response.sendRedirect(contextPath + "/login.action?os_destination=" + URLEncoder.encode(relativeRequestPath, "UTF-8"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConfluenceUser user;
        boolean isLogin = Boolean.parseBoolean(request.getParameter("in-confluence-to-start-oauth"));
        if (isLogin && (user = AuthenticatedUserThreadLocal.get()) == null) {
            this.redirectToLoginPage(request, response);
            return;
        }
        PrintWriter out = response.getWriter();
        response.setContentType("text/html;charset=UTF-8");
        HashMap<String, SoyTemplateRenderer> context = new HashMap<String, SoyTemplateRenderer>();
        context.put("soyTemplateRenderer", this.soyTemplateRenderer);
        try {
            this.soyTemplateRenderer.render((Appendable)out, RESOURCE_KEY, TEMPLATE_KEY, context);
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }
}

