/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.rest;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/configsettings")
@Internal
public class SpaceToRoomConfigSettingsResource {
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final HipChatSpaceToRoomService hipChatSpaceToRoomService;

    public SpaceToRoomConfigSettingsResource(SpaceManager spaceManager, PermissionManager permissionManager, HipChatSpaceToRoomService hipChatSpaceToRoomService) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.hipChatSpaceToRoomService = hipChatSpaceToRoomService;
    }

    @PUT
    @Path(value="/notifyclient/{spaceKey}/{roomId}")
    public Response enableNotifyClient(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="roomId") String roomId) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (!this.isSpaceAdmin(space)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.hipChatSpaceToRoomService.setClientNotifyForSpaceAndRoom(spaceKey, roomId, true);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/notifyclient/{spaceKey}/{roomId}")
    public Response removeNotification(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="roomId") String roomId) {
        if (!this.isSpaceAdmin(spaceKey)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.hipChatSpaceToRoomService.setClientNotifyForSpaceAndRoom(spaceKey, roomId, false);
        return Response.ok().build();
    }

    private boolean isSpaceAdmin(String spaceKey) {
        return this.isSpaceAdmin(this.spaceManager.getSpace(spaceKey));
    }

    @VisibleForTesting
    boolean isSpaceAdmin(Space space) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space) || this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

