/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications;

import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.NotificationMessageBuilder;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.SpaceToRoomNotification;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogo;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.hipchat.api.icons.ADGIcon;
import com.atlassian.hipchat.api.icons.DefaultIcon;
import com.atlassian.hipchat.api.icons.Icon;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import io.atlassian.fugue.Option;
import java.net.MalformedURLException;
import java.net.URL;

public class ExampleNotification
extends SpaceToRoomNotification<SpaceUpdateEvent> {
    private ApplicationProperties applicationProperties;
    private SpaceManager spaceManager;

    public ExampleNotification(NotificationMessageBuilder notificationMessageBuilder) {
        this.notificationMessageBuilder = notificationMessageBuilder;
    }

    @Override
    public Icon getIcon(SpaceUpdateEvent event) {
        SpaceLogo logo = this.spaceManager.getLogoForSpace(event.getSpace().getKey());
        String url = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + logo.getDownloadPath();
        try {
            return new DefaultIcon(new URL(url));
        }
        catch (MalformedURLException e) {
            return ADGIcon.SUCCESS;
        }
    }

    @Override
    public Option<UserKey> getUser(SpaceUpdateEvent event) {
        ConfluenceUser creator = event.getSpace().getCreator();
        if (creator != null) {
            Option.some((Object)creator.getKey());
        }
        return Option.none();
    }

    @Override
    public String getLink(SpaceUpdateEvent event) {
        Space space = event.getSpace();
        return String.format("<a href=\"%s\"><b>%s</b></a>", GeneralUtil.escapeForHtmlAttribute((String)this.linkUrl(space)), GeneralUtil.escapeXMLCharacters((String)space.getName()));
    }

    private String linkUrl(Space space) {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + space.getUrlPath();
    }

    @Override
    public String getMessageKey(SpaceUpdateEvent event) {
        return "hipchat.notification.space-updated";
    }

    @Override
    public Option<Space> getSpace(SpaceUpdateEvent event) {
        return Option.some((Object)event.getSpace());
    }

    public Class<SpaceUpdateEvent> getEventClass() {
        return SpaceUpdateEvent.class;
    }

    public boolean shouldSend(SpaceUpdateEvent event) {
        return true;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

