/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.model;

import com.atlassian.confluence.api.model.content.ContentType;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ObjectUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class ConfluenceContentItem
implements Comparable<ConfluenceContentItem> {
    public static final long NO_CONTENT_ID = 0L;
    @JsonProperty
    private final int level;
    @JsonProperty
    private final long contentId;
    @JsonProperty
    private final String title;
    @JsonProperty
    private final String url;
    @JsonProperty
    private final String spaceName;
    @JsonProperty
    private final ContentType type;
    @JsonProperty
    private final String changeType;
    @JsonProperty
    private final String excerpt;
    @JsonProperty
    private final long updatedTimestamp;

    @JsonCreator
    public ConfluenceContentItem(@JsonProperty(value="level") int level, @JsonProperty(value="contentId") long contentId, @JsonProperty(value="title") String title, @JsonProperty(value="url") String url, @JsonProperty(value="spaceName") String spaceName, @JsonProperty(value="type") ContentType type, @JsonProperty(value="changeType") String changeType, @JsonProperty(value="excerpt") String excerpt, @JsonProperty(value="updatedTimestamp") long updatedTimestamp) {
        this.level = level;
        this.contentId = contentId;
        this.title = title;
        this.url = url;
        this.spaceName = spaceName;
        this.type = type;
        this.changeType = changeType;
        this.excerpt = excerpt;
        this.updatedTimestamp = updatedTimestamp;
    }

    public int getLevel() {
        return this.level;
    }

    public long getContentId() {
        return this.contentId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public ContentType getType() {
        return this.type;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluenceContentItem item = (ConfluenceContentItem)o;
        if (this.contentId != item.contentId) {
            return false;
        }
        if (this.title != null ? !this.title.equals(item.title) : item.title != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(item.url) : item.url != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)item.type) : item.type != null) {
            return false;
        }
        return !(this.spaceName != null ? !this.spaceName.equals(item.spaceName) : item.spaceName != null);
    }

    public int hashCode() {
        int result = (int)(this.contentId ^ this.contentId >>> 32);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.spaceName != null ? this.spaceName.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfluenceContentItems{title=" + this.title + ", url='" + this.url + '\'' + ", type='" + this.type + '\'' + '}';
    }

    @Override
    public int compareTo(ConfluenceContentItem other) {
        Preconditions.checkNotNull((Object)other);
        int compare = ObjectUtils.compare((Comparable)Long.valueOf(this.contentId), (Comparable)Long.valueOf(other.contentId));
        if (compare == 0 && (compare = ObjectUtils.compare((Comparable)((Object)this.title), (Comparable)((Object)other.title))) == 0 && (compare = ObjectUtils.compare((Comparable)((Object)this.url), (Comparable)((Object)other.url))) == 0) {
            compare = ObjectUtils.compare((Comparable)((Object)this.spaceName), (Comparable)((Object)other.spaceName));
        }
        return compare;
    }
}

