/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.HipChatRoomDefinition;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.RoomProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomSettings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Immutable
public class SpaceToRoomConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SpaceToRoomConfiguration.class);
    private final Map<HipChatRoomDefinition, SpaceToRoomSettings> roomDefinitionSpaceToRoomSettings;
    private final Space space;

    private SpaceToRoomConfiguration(Space space, Map<HipChatRoomDefinition, SpaceToRoomSettings> configuration) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull((Object)space);
        this.roomDefinitionSpaceToRoomSettings = configuration;
        this.space = space;
    }

    public Option<Set<NotificationType>> getRoomConfiguration(HipChatRoomDefinition room) {
        SpaceToRoomSettings settings = this.roomDefinitionSpaceToRoomSettings.get(room);
        if (settings == null) {
            return Option.none();
        }
        Set<NotificationType> enabledNotifications = settings.getNotificationTypes();
        if (enabledNotifications == null) {
            return Option.none();
        }
        return Option.some(Collections.unmodifiableSet(enabledNotifications));
    }

    public boolean isRoomNotificationEnabled(HipChatRoomDefinition room, NotificationType spaceToRoomNotification) {
        Preconditions.checkNotNull((Object)room);
        Preconditions.checkNotNull((Object)spaceToRoomNotification);
        Option<Set<NotificationType>> notifications = this.getRoomConfiguration(room);
        if (notifications.isDefined()) {
            return ((Set)notifications.get()).contains(spaceToRoomNotification);
        }
        return false;
    }

    public boolean isNotifyClientEnabled(HipChatRoomDefinition room) {
        SpaceToRoomSettings settings = this.roomDefinitionSpaceToRoomSettings.get(room);
        if (settings == null) {
            return false;
        }
        return settings.isNotifyClient();
    }

    public Map<HipChatRoomDefinition, SpaceToRoomSettings> getAllSpaceSettings() {
        return Collections.unmodifiableMap(this.roomDefinitionSpaceToRoomSettings);
    }

    public Space getSpace() {
        return this.space;
    }

    public Set<HipChatRoomDefinition> getConfiguredRooms() {
        Ordering ordering = Ordering.from(HipChatRoomDefinition.ORDER_BY_STATE).compound(HipChatRoomDefinition.ORDER_BY_NAME);
        return ImmutableSortedSet.copyOf((Comparator)ordering, this.roomDefinitionSpaceToRoomSettings.keySet());
    }

    public Set<HipChatRoomDefinition> getRoomsForNotification(NotificationType notification) {
        Preconditions.checkNotNull((Object)notification);
        HashSet<HipChatRoomDefinition> rooms = new HashSet<HipChatRoomDefinition>();
        for (Map.Entry<HipChatRoomDefinition, SpaceToRoomSettings> entry : this.roomDefinitionSpaceToRoomSettings.entrySet()) {
            Set<NotificationType> notificationTypes = entry.getValue().getNotificationTypes();
            if (notificationTypes == null || !notificationTypes.contains(notification)) continue;
            rooms.add(entry.getKey());
        }
        return rooms;
    }

    public static class Builder {
        private final Map<String, SpaceToRoomSettings.Builder> roomSettingBuilders = new HashMap<String, SpaceToRoomSettings.Builder>();
        private final Space space;
        private final RoomProvider roomProvider;

        public Builder(Space space, RoomProvider roomProvider) {
            Preconditions.checkNotNull((Object)space);
            Preconditions.checkNotNull((Object)roomProvider);
            this.space = space;
            this.roomProvider = roomProvider;
        }

        public SpaceToRoomConfiguration build() {
            HashMap<HipChatRoomDefinition, SpaceToRoomSettings> configuration = new HashMap<HipChatRoomDefinition, SpaceToRoomSettings>();
            for (Map.Entry<String, SpaceToRoomSettings.Builder> entry : this.roomSettingBuilders.entrySet()) {
                String roomId = entry.getKey();
                HipChatRoomDefinition room = this.roomProvider.getRoom(roomId);
                SpaceToRoomSettings settings = entry.getValue().build();
                configuration.put(room, settings);
            }
            return new SpaceToRoomConfiguration(this.space, configuration);
        }

        public SpaceToRoomSettings.Builder getSettingsBuilder(String roomId) {
            SpaceToRoomSettings.Builder builder = this.roomSettingBuilders.get(roomId);
            if (builder == null) {
                builder = new SpaceToRoomSettings.Builder();
                this.roomSettingBuilders.put(roomId, builder);
            }
            return builder;
        }
    }
}

