/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration;

import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class HipChatRoomDefinition {
    private final String roomName;
    private final String roomId;
    private final boolean roomPrivate;
    private final RoomState roomState;
    public static final Comparator<HipChatRoomDefinition> ORDER_BY_STATE = new Comparator<HipChatRoomDefinition>(){

        @Override
        public int compare(HipChatRoomDefinition room1, HipChatRoomDefinition room2) {
            return room1.getRoomState().ordinal() - room2.getRoomState().ordinal();
        }
    };
    public static final Comparator<HipChatRoomDefinition> ORDER_BY_NAME = new Comparator<HipChatRoomDefinition>(){

        @Override
        public int compare(HipChatRoomDefinition room1, HipChatRoomDefinition room2) {
            return String.CASE_INSENSITIVE_ORDER.compare(room1.getRoomName(), room2.getRoomName());
        }
    };

    @JsonCreator
    public HipChatRoomDefinition(@JsonProperty(value="roomName") String roomName, @JsonProperty(value="roomId") String roomId, @JsonProperty(value="roomPrivate") boolean roomPrivate, @JsonProperty(value="visible") RoomState roomState) {
        Preconditions.checkNotNull((Object)roomName);
        Preconditions.checkNotNull((Object)roomId);
        this.roomName = roomName;
        this.roomId = roomId;
        this.roomPrivate = roomPrivate;
        this.roomState = roomState;
    }

    public HipChatRoomDefinition(boolean roomPrivate, String roomId, String roomName) {
        this.roomPrivate = roomPrivate;
        this.roomId = roomId;
        this.roomName = roomName;
        this.roomState = RoomState.Visible;
    }

    public HipChatRoomDefinition(CollapsedRoom room) {
        this.roomName = room.getName();
        this.roomId = room.getId();
        this.roomPrivate = room.isPrivate();
        this.roomState = RoomState.Visible;
        Preconditions.checkNotNull((Object)this.roomName);
        Preconditions.checkNotNull((Object)this.roomId);
    }

    @JsonProperty
    public String getRoomName() {
        return this.roomName;
    }

    @JsonProperty
    public String getRoomId() {
        return this.roomId;
    }

    @JsonProperty
    public boolean isRoomPrivate() {
        return this.roomPrivate;
    }

    @JsonProperty
    public RoomState getRoomState() {
        return this.roomState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HipChatRoomDefinition that = (HipChatRoomDefinition)o;
        return !(this.roomId != null ? !this.roomId.equals(that.roomId) : that.roomId != null);
    }

    public int hashCode() {
        return this.roomId != null ? this.roomId.hashCode() : 0;
    }

    public String toString() {
        return "HipChatRoomDefinition{roomId='" + this.roomId + '\'' + ", roomName='" + this.roomName + '\'' + ", roomPrivate='" + this.roomPrivate + '\'' + '}';
    }

    public static enum RoomState {
        Visible,
        Restricted,
        NotFound,
        Unknown;


        public static RoomState fromStatusCode(int code) {
            if (code < 0) {
                return Unknown;
            }
            switch (Response.Status.fromStatusCode((int)code)) {
                case OK: {
                    return Visible;
                }
                case FORBIDDEN: {
                    return Restricted;
                }
                case NOT_FOUND: {
                    return NotFound;
                }
            }
            return Unknown;
        }
    }
}

