require([
        'underscore',
        'hipchat/invite/user-picker'
    ],
    function (_,
        inviteUserPicker) {
        AJS.toInit(function ($) {
            var form = $('#hipchat-invite-form');
            var userField = form.find('#hipchat-invite-user');
            var restBaseUrl = AJS.contextPath() + AJS.REST.getBaseUrl();

            function makeParams(val) {
                return {
                    "max-results": 10,
                    query: val.replace("{|}", "") // remove curly braces as jersey doesn't like them
                };
            }

            function processResults(data, page) {
                var results = _.reduce(data.result, function (m, item) {
                    if (item.type !== 'group') {
                        m.push({
                            id: item.username,
                            text: item.title,
                            restObj: item
                        });
                    }
                    return m;
                }, []);
                return {
                    results: results
                };
            }

            function processChoice(props) {
                var deferred = $.Deferred();

                getEmail(props.restObj.username).always(function(email) {
                    var choice = {
                        username: props.restObj.username,
                        fullname: props.restObj.title,
                        avatarUrl: props.restObj.thumbnailLink.href,
                        email: email
                    };

                    deferred.resolve(choice);
                });

                return deferred.promise();
            }

            function getEmail(username) {
                var url = restBaseUrl + "user/non-system/" + encodeURIComponent(username) + ".json";
                var deferred = $.Deferred();

                $.ajax(url, {
                    type: "GET",
                    dataType: 'json',
                    contentType: 'application/json'
                }).always(function(data) {
                    deferred.resolve(data && data.displayableEmail);
                });

                return deferred.promise();
            }

            inviteUserPicker(userField, form, {
                url: restBaseUrl + "search/user-or-group.json",
                params: makeParams,
                results: processResults,
                choice: processChoice
            });
        })

    });
