/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.user;

import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.SearchTokenExpiredException;
import com.atlassian.confluence.search.v2.SearchWithToken;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.hipchat.user.HipChatUserValidator;
import com.atlassian.plugins.hipchat.user.InviteUserHelper;
import com.atlassian.plugins.hipchat.user.UserReference;
import com.atlassian.plugins.hipchat.user.UserReferenceSet;
import com.atlassian.plugins.hipchat.user.UserReferenceSetBuilder;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Nullable;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceInviteUserReferenceSetBuilder
implements UserReferenceSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceInviteUserReferenceSetBuilder.class);
    private static final int MAX_RESULTS_PER_SEARCH_PAGE = 50;
    private static final int MAX_SEARCH_PAGE_COUNT_FACTOR = 2;
    private final SearchManager searchManager;
    private final UserAccessor userAccessor;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public ConfluenceInviteUserReferenceSetBuilder(SearchManager searchManager, UserAccessor userAccessor, WebResourceUrlProvider webResourceUrlProvider) {
        this.searchManager = (SearchManager)Preconditions.checkNotNull((Object)searchManager);
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Preconditions.checkNotNull((Object)webResourceUrlProvider);
    }

    public UserReferenceSet build(int maxUsers, @Nullable Set<String> spaceKeys) throws InvalidSearchException, SearchTokenExpiredException {
        logger.debug("Building UserReferenceSet...");
        HashMap<UserKey, UserReference> userKeysToReferences = new HashMap<UserKey, UserReference>(maxUsers);
        ConfluenceUser currentUserToExclude = AuthenticatedUserThreadLocal.get();
        this.searchForUserNames(userKeysToReferences, maxUsers, spaceKeys, currentUserToExclude);
        Collection usersCollection = userKeysToReferences.values();
        HashSet userReferencesSet = Sets.newHashSet(usersCollection);
        UserReferenceSet userReferenceSet = new UserReferenceSet((Set)userReferencesSet);
        return userReferenceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForUserNames(Map<UserKey, UserReference> userKeysToReferences, int maxUsers, @Nullable Set<String> spaceKeys, ConfluenceUser currentUserToExclude) throws InvalidSearchException, SearchTokenExpiredException {
        String name = "ConfluenceInviteUserReferenceSetBuilder::searchForUserNames(SearchQuery, String, Calendar, String):Set<AbstractPage>";
        UtilTimerStack.push((String)"ConfluenceInviteUserReferenceSetBuilder::searchForUserNames(SearchQuery, String, Calendar, String):Set<AbstractPage>");
        try {
            UserKey currentUserKeyToExclude = currentUserToExclude == null ? null : currentUserToExclude.getKey();
            Object spacesSearchQuery = spaceKeys == null || spaceKeys.size() == 0 ? new SpaceCategoryQuery(SpaceCategoryEnum.GLOBAL) : new InSpaceQuery(spaceKeys);
            SearchResults searchResults = this.searchSpacesForInitialResults((SearchQuery)spacesSearchQuery, 50);
            this.processSearchResults(currentUserToExclude, userKeysToReferences, maxUsers, searchResults, currentUserKeyToExclude);
            int minPagesRequired = (int)Math.ceil((double)maxUsers / 50.0);
            int maxPagesAllowed = minPagesRequired * 2;
            for (int pageCount = 1; userKeysToReferences.size() < maxUsers && !searchResults.isLastPage() && pageCount < maxPagesAllowed; ++pageCount) {
                SearchWithToken searchWithToken = searchResults.getNextPageSearch();
                searchResults = this.searchSpacesForSubsequentResults(searchWithToken);
                this.processSearchResults(currentUserToExclude, userKeysToReferences, maxUsers, searchResults, currentUserKeyToExclude);
            }
        }
        finally {
            UtilTimerStack.pop((String)"ConfluenceInviteUserReferenceSetBuilder::searchForUserNames(SearchQuery, String, Calendar, String):Set<AbstractPage>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults searchSpacesForInitialResults(SearchQuery searchQuery, int resultsPerPage) throws InvalidSearchException {
        String name = "ConfluenceInviteUserReferenceSetBuilder::searchSpacesForInitialResults(SearchManager, SearchQuery):SearchResults";
        UtilTimerStack.push((String)"ConfluenceInviteUserReferenceSetBuilder::searchSpacesForInitialResults(SearchManager, SearchQuery):SearchResults");
        try {
            SearchResults searchResults;
            CreatedSort sort = CreatedSort.DESCENDING;
            ContentPermissionsSearchFilter searchFilter = ContentPermissionsSearchFilter.getInstance();
            boolean startOffset = false;
            ContentSearch search = new ContentSearch(searchQuery, (SearchSort)sort, (SearchFilter)searchFilter, 0, resultsPerPage);
            SearchResults searchResults2 = searchResults = this.searchManager.search((ISearch)search);
            return searchResults2;
        }
        finally {
            UtilTimerStack.pop((String)"ConfluenceInviteUserReferenceSetBuilder::searchSpacesForInitialResults(SearchManager, SearchQuery):SearchResults");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults searchSpacesForSubsequentResults(SearchWithToken searchWithToken) throws SearchTokenExpiredException, InvalidSearchException {
        String name = "ConfluenceInviteUserReferenceSetBuilder::searchSpacesForSubsequentResults(SearchManager, SearchQuery):SearchResults";
        UtilTimerStack.push((String)"ConfluenceInviteUserReferenceSetBuilder::searchSpacesForSubsequentResults(SearchManager, SearchQuery):SearchResults");
        try {
            SearchResults searchResults;
            SearchResults searchResults2 = searchResults = this.searchManager.search(searchWithToken);
            return searchResults2;
        }
        finally {
            UtilTimerStack.pop((String)"ConfluenceInviteUserReferenceSetBuilder::searchSpacesForSubsequentResults(SearchManager, SearchQuery):SearchResults");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSearchResults(ConfluenceUser currentUserToExclude, Map<UserKey, UserReference> userKeysToReferences, int maxUsers, SearchResults searchResults, UserKey currentUserKeyToExclude) {
        String name = "ConfluenceInviteUserReferenceSetBuilder::processSearchResults(Set<String>, int, SearchResults):Void";
        UtilTimerStack.push((String)"ConfluenceInviteUserReferenceSetBuilder::processSearchResults(Set<String>, int, SearchResults):Void");
        try {
            List searchResultItems = searchResults.getAll();
            for (SearchResult searchResult : searchResultItems) {
                boolean keepIterating;
                boolean matched = this.processSearchResult(currentUserToExclude, userKeysToReferences, searchResult, currentUserKeyToExclude);
                if (!matched || (keepIterating = userKeysToReferences.size() < maxUsers)) continue;
                break;
            }
        }
        finally {
            UtilTimerStack.pop((String)"ConfluenceInviteUserReferenceSetBuilder::processSearchResults(Set<String>, int, SearchResults):Void");
        }
    }

    private boolean processSearchResult(ConfluenceUser currentUserToExclude, Map<UserKey, UserReference> userKeysToReferences, SearchResult searchResult, UserKey currentUserKeyToExclude) {
        boolean matched = false;
        String searchResultType = searchResult.getType();
        if (searchResultType.equals("page")) {
            ConfluenceUser lastPageEditor = searchResult.getLastModifierUser();
            if (lastPageEditor == null) {
                lastPageEditor = searchResult.getCreatorUser();
            }
            if (lastPageEditor != null) {
                String email;
                ConfluenceUser user;
                UserKey userKey = lastPageEditor.getKey();
                if (!(currentUserKeyToExclude != null && currentUserKeyToExclude.equals((Object)userKey) || userKeysToReferences.get(userKey) != null || (user = this.userAccessor.getExistingUserByKey(userKey)) == null || (email = user.getEmail()) == null || email.trim().length() <= 0 || InviteUserHelper.USERS_MUST_HAVE_SAME_DOMAIN_EMAIL && !InviteUserHelper.haveSameEmailDomains((String)currentUserToExclude.getEmail(), (String)email))) {
                    String userName = lastPageEditor.getName();
                    String displayName = user.getFullName();
                    String profilePictureUri = this.findProfilePicture(user);
                    UserReference userReference = new UserReference(userKey.getStringValue(), userName, email, displayName, profilePictureUri);
                    if (HipChatUserValidator.satisfiesHipChatUserRequirements((UserReference)userReference)) {
                        userKeysToReferences.put(userKey, userReference);
                        matched = true;
                    }
                }
            }
        }
        return matched;
    }

    private String findProfilePicture(ConfluenceUser user) {
        ProfilePictureInfo userProfilePicture = this.userAccessor.getUserProfilePicture((User)user);
        if (userProfilePicture == null) {
            return null;
        }
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.RELATIVE) + userProfilePicture.getDownloadPath();
    }
}

