/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.webpanel;

import com.atlassian.sal.api.ApplicationProperties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CQLAvailabilityProvider {
    private static final Logger logger = LoggerFactory.getLogger(CQLAvailabilityProvider.class);
    private final ApplicationProperties applicationProperties;
    private final AtomicReference<Availability> availabilityRef = new AtomicReference<Availability>(Availability.UNKNOWN);
    private final int minMajorVersion;
    private final int minMinorVersion;

    public CQLAvailabilityProvider(ApplicationProperties applicationProperties, int minMajorVersion, int minMinorVersion) {
        this.applicationProperties = applicationProperties;
        this.minMajorVersion = minMajorVersion;
        this.minMinorVersion = minMinorVersion;
    }

    public boolean isAvailable() {
        Availability availability = this.availabilityRef.get();
        if (availability == Availability.UNKNOWN) {
            availability = this.evaluateAvailability();
            this.availabilityRef.set(availability);
        }
        return availability == Availability.AVAILABLE;
    }

    private Availability evaluateAvailability() {
        boolean available;
        int[] version = this.getVersion();
        boolean bl = available = version[0] > this.minMajorVersion || version[0] >= this.minMajorVersion && version[1] >= this.minMinorVersion;
        if (available) {
            return Availability.AVAILABLE;
        }
        return Availability.UNAVAILABLE;
    }

    private int[] getVersion() {
        String applicationVersion = this.applicationProperties.getVersion();
        try {
            String[] applicationVersionParts = applicationVersion.split("\\.");
            if (applicationVersionParts.length >= 2) {
                int majorVersion = Integer.parseInt(applicationVersionParts[0]);
                int minorVersion = Integer.parseInt(applicationVersionParts[1]);
                return new int[]{majorVersion, minorVersion};
            }
            return new int[]{0, 0};
        }
        catch (NumberFormatException e) {
            logger.warn("Unable to parser version " + applicationVersion + '.');
            return new int[]{0, 0};
        }
    }

    private static enum Availability {
        UNKNOWN,
        UNAVAILABLE,
        AVAILABLE;

    }
}

