/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.HSQLDialect;
import net.sf.hibernate.dialect.MySQLDialect;
import net.sf.hibernate.dialect.Oracle9Dialect;
import net.sf.hibernate.dialect.OracleDialect;
import net.sf.hibernate.dialect.OracleIntlDialect;
import net.sf.hibernate.dialect.PostgreSQLDialect;
import net.sf.hibernate.dialect.SQLServerDialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;

public class HibernateUtil {
    private static final Map<Class<? extends Dialect>, SQLDialect> HIBERNATE_TO_SQL_TEMPLATE_MAPPING = ImmutableMap.builder().put(HSQLDialect.class, (Object)SQLDialect.HSQL).put(MySQLDialect.class, (Object)SQLDialect.MySQl).put(PostgreSQLDialect.class, (Object)SQLDialect.Postgres).put(SQLServerDialect.class, (Object)SQLDialect.MSSQL).put(OracleDialect.class, (Object)SQLDialect.Oracle).put(Oracle9Dialect.class, (Object)SQLDialect.Oracle).put(OracleIntlDialect.class, (Object)SQLDialect.Oracle).build();

    public static SQLDialect getDialect(Session session) {
        Preconditions.checkNotNull((Object)session);
        Class<? extends Dialect> dialect = HibernateUtil.getHibernateDialect(session);
        if (dialect != null) {
            for (Map.Entry<Class<? extends Dialect>, SQLDialect> entry : HIBERNATE_TO_SQL_TEMPLATE_MAPPING.entrySet()) {
                if (!entry.getKey().isAssignableFrom(dialect)) continue;
                return entry.getValue();
            }
        }
        return SQLDialect.Unknown;
    }

    private static Class<? extends Dialect> getHibernateDialect(Session session) {
        SessionFactory hibernateSessionFactory = session.getSessionFactory();
        if (hibernateSessionFactory instanceof SessionFactoryImplementor) {
            return ((SessionFactoryImplementor)hibernateSessionFactory).getDialect().getClass();
        }
        return null;
    }

    public static enum SQLDialect {
        HSQL,
        MSSQL,
        Postgres,
        MySQl,
        Oracle,
        Unknown;

    }
}

