/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.SpacesWithAdminPermissionProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.HibernateUtil;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.hipchat.api.Result;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpacesWithAdminPermissionProvider
implements SpacesWithAdminPermissionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSpacesWithAdminPermissionProvider.class);
    @VisibleForTesting
    static final String QUERY_WITH_GROUPS = "select space.name, space.key from SpacePermission as perm inner join perm.space as space where (perm.userSubject = :user or perm.group in (:groups) or (perm.userSubject is null and perm.group is null)) and (perm.type = :permission) and space.spaceStatus = :status and lower(space.name) like lower(:name)";
    @VisibleForTesting
    static final String QUERY_WITH_NO_GROUPS = "select space.name, space.key from SpacePermission as perm inner join perm.space as space where perm.type = :permission and perm.group is null and (perm.userSubject = :user or perm.userSubject is null) and space.spaceStatus = :status and lower(space.name) like lower(:name)";
    @VisibleForTesting
    static final String QUERY_ADMIN = "select space.name, space.key from Space as space where space.spaceStatus = :status and lower(space.name) like lower(:name)";
    @VisibleForTesting
    static final String QUERY_ORDER_LENGTH = " order by length(space.name) asc";
    @VisibleForTesting
    static final String QUERY_ORDER_LENGTH_MSSQL = " order by len(space.name) asc";
    private final PluginHibernateSessionFactory pluginHibernateSessionFactory;
    private final UserAccessor userAccessor;
    private final UserManager userManager;

    public DefaultSpacesWithAdminPermissionProvider(PluginHibernateSessionFactory pluginHibernateSessionFactory, UserAccessor userAccessor, UserManager userManager) {
        Preconditions.checkNotNull((Object)pluginHibernateSessionFactory);
        Preconditions.checkNotNull((Object)userAccessor);
        Preconditions.checkNotNull((Object)userManager);
        this.userManager = userManager;
        this.pluginHibernateSessionFactory = pluginHibernateSessionFactory;
        this.userAccessor = userAccessor;
    }

    @Override
    public Result<Iterable<SpacesWithAdminPermissionProvider.SpaceResult>> findSpacesMatchingName(String name, ConfluenceUser user, int maxResults) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0);
        Session session = this.pluginHibernateSessionFactory.getSession();
        try {
            Query query;
            if (this.userManager.isAdmin(user.getKey())) {
                query = session.createQuery(QUERY_ADMIN + this.queryOrderBy(session));
            } else {
                List userGroups = this.userAccessor.getGroupNamesForUserName(user.getName());
                if (userGroups.isEmpty()) {
                    query = session.createQuery(QUERY_WITH_NO_GROUPS + this.queryOrderBy(session));
                } else {
                    query = session.createQuery(QUERY_WITH_GROUPS + this.queryOrderBy(session));
                    query.setParameterList("groups", this.filterBlanks(userGroups));
                }
                query.setParameter("permission", (Object)"SETSPACEPERMISSIONS");
                query.setParameter("user", (Object)user);
            }
            query.setParameter("name", (Object)(name + "%"));
            query.setParameter("status", (Object)SpaceStatus.CURRENT.toString());
            query.setCacheable(false);
            query.setMaxResults(maxResults);
            return Result.success((Object)Iterables.transform((Iterable)query.list(), this.toSpaceResult()));
        }
        catch (HibernateException hibernateException) {
            LOGGER.warn("Error encountered querying space list", (Throwable)hibernateException);
            return Result.error((Throwable)hibernateException);
        }
    }

    private Function<Object[], SpacesWithAdminPermissionProvider.SpaceResult> toSpaceResult() {
        return new Function<Object[], SpacesWithAdminPermissionProvider.SpaceResult>(){

            public SpacesWithAdminPermissionProvider.SpaceResult apply(Object[] input) {
                Preconditions.checkNotNull((Object)input);
                Preconditions.checkElementIndex((int)1, (int)input.length);
                return new SpacesWithAdminPermissionProvider.SpaceResult((String)input[0], (String)input[1]);
            }
        };
    }

    private List<String> filterBlanks(List<String> userGroups) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String userGroup : userGroups) {
            if (StringUtils.isBlank((CharSequence)userGroup)) continue;
            builder.add((Object)userGroup);
        }
        return builder.build();
    }

    private String queryOrderBy(Session session) {
        HibernateUtil.SQLDialect dialect = HibernateUtil.getDialect(session);
        LOGGER.debug("Using {} as dialect for space query");
        switch (dialect) {
            case MSSQL: {
                return QUERY_ORDER_LENGTH_MSSQL;
            }
        }
        return QUERY_ORDER_LENGTH;
    }
}

