/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration;

import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SpaceToRoomSettings {
    private final Set<NotificationType> notificationTypes;
    private final boolean notifyClient;

    private SpaceToRoomSettings(Set<NotificationType> notificationTypes, boolean notifyClient) {
        this.notificationTypes = notificationTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(notificationTypes);
        this.notifyClient = notifyClient;
    }

    public Set<NotificationType> getNotificationTypes() {
        return Collections.unmodifiableSet(this.notificationTypes);
    }

    public boolean isNotifyClient() {
        return this.notifyClient;
    }

    public static class Builder {
        private Set<NotificationType> notificationsTypes = new HashSet<NotificationType>();
        private boolean notifyClient = false;

        public Builder addNotificationType(NotificationType type) {
            if (type != null) {
                this.notificationsTypes.add(type);
            }
            return this;
        }

        public Builder addNotificationTypes(Collection<NotificationType> types) {
            if (types != null) {
                this.notificationsTypes.addAll(types);
            }
            return this;
        }

        public Builder setNotifyClient(Boolean notifyClient) {
            this.notifyClient = notifyClient == null ? false : notifyClient;
            return this;
        }

        public SpaceToRoomSettings build() {
            return new SpaceToRoomSettings(this.notificationsTypes, this.notifyClient);
        }
    }
}

