/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.upgrade.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.annotations.Internal;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.upgrade.v1.SpaceToRoomBandanaToAoMigrator;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BandanaToAoMigrationController
implements ActiveObjectsUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(BandanaToAoMigrationController.class);
    static final ModelVersion RESULT_ROOM_TO_SPACE_SCHEMA_VERSION = ModelVersion.valueOf((String)"1");
    private final BandanaManager bandanaManager;

    public BandanaToAoMigrationController(BandanaManager bandanaManager) {
        Preconditions.checkNotNull((Object)bandanaManager);
        this.bandanaManager = bandanaManager;
    }

    public ModelVersion getModelVersion() {
        return RESULT_ROOM_TO_SPACE_SCHEMA_VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isOlderThan(RESULT_ROOM_TO_SPACE_SCHEMA_VERSION));
        Preconditions.checkNotNull((Object)ao);
        logger.debug("Upgrading from Bandana to AO...");
        SpaceToRoomBandanaToAoMigrator.migrateData(this.bandanaManager, ao);
    }
}

