/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.discovery;

import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.confluence.plugins.hipchat.discovery.HipChatDiscoveryConditionSupplier;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.user.User;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatIntegrationDiscoveryService {
    private static final HipChatDiscoveryData DO_NOT_DISCOVER_HIPCHAT = new HipChatDiscoveryData(false, false, false);
    private static final long MAX_DISCOVERY_WAIT_SECONDS = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HipChatIntegrationDiscoveryService.class);
    private final HipChatLinkProvider hipChatLinkProvider;
    private final PermissionManager permissionManager;
    private final CachedReference<Boolean> reference;
    private boolean failedDiscovery = false;

    public HipChatIntegrationDiscoveryService(CacheFactory cacheFactory, HipChatLinkProvider hipChatLinkProvider, SpaceManager spaceManager, PermissionManager permissionManager, SearchManager searchManager) {
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.permissionManager = permissionManager;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.reference = cacheFactory.getCachedReference(HipChatIntegrationDiscoveryService.class, "conditionsMet", new HipChatDiscoveryConditionSupplier(spaceManager, searchManager), cacheSettings);
    }

    public HipChatDiscoveryData getDiscoveryData() {
        if (this.failedDiscovery) {
            return DO_NOT_DISCOVER_HIPCHAT;
        }
        final boolean isAdmin = this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
        ExecutorService impatientService = Executors.newSingleThreadExecutor();
        Future<HipChatDiscoveryData> discoveryFuture = impatientService.submit(new Callable<HipChatDiscoveryData>(){

            @Override
            public HipChatDiscoveryData call() throws Exception {
                boolean hasLink = HipChatIntegrationDiscoveryService.this.hipChatLinkProvider.isAnyLinkDefined();
                boolean conditionsMet = !hasLink ? (Boolean)HipChatIntegrationDiscoveryService.this.reference.get() : true;
                return new HipChatDiscoveryData(hasLink, conditionsMet, isAdmin);
            }
        });
        try {
            return discoveryFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        LOGGER.warn("Unable to access Hipchat discovery data - disabling. Probably due to the Hipchat Integration Core Plugin being disabled.");
        this.failedDiscovery = true;
        return DO_NOT_DISCOVER_HIPCHAT;
    }

    @Immutable
    static class HipChatDiscoveryData {
        private final boolean linkActive;
        private final boolean conditionsMet;
        private final boolean admin;

        private HipChatDiscoveryData(boolean linkActive, boolean conditionsMet, boolean admin) {
            this.linkActive = linkActive;
            this.conditionsMet = conditionsMet;
            this.admin = admin;
        }

        @JsonProperty
        public boolean isLinkActive() {
            return this.linkActive;
        }

        @JsonProperty
        public boolean isAdmin() {
            return this.admin;
        }

        @JsonProperty
        public boolean isConditionsMet() {
            return this.conditionsMet;
        }
    }
}

