/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.confluence.content.render.xhtml.editor.inline.EmoticonDisplayMapper;
import com.atlassian.confluence.content.render.xhtml.model.inline.Emoticon;
import com.atlassian.confluence.plugins.hipchat.emoticons.HipChatEmoticon;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class EmoticonModel
implements Serializable {
    private static final Function<HipChatEmoticon, EmoticonModel> HIPCHAT_EMOTICON_TO_MODEL = input -> new EmoticonModel(input.getUrl(), input.getShortcut());
    @JsonProperty
    private String url;
    @JsonProperty
    private String shortcut;
    @JsonProperty
    private String name;

    public EmoticonModel(String url, String shortcut) {
        this(url, shortcut, null);
    }

    public EmoticonModel(String url, String shortcut, String name) {
        this.url = url;
        this.shortcut = shortcut;
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public String getName() {
        return this.name;
    }

    public static Function<HipChatEmoticon, EmoticonModel> fromHipChatEmoticon() {
        return HIPCHAT_EMOTICON_TO_MODEL;
    }

    public static Function<Map.Entry<Emoticon, String>, EmoticonModel> fromConfluenceEmoticon(EmoticonDisplayMapper emoticonDisplayMapper) {
        return input -> new EmoticonModel(emoticonDisplayMapper.getAbsoluteImageUrl((Emoticon)input.getKey()), (String)input.getValue(), ((Emoticon)input.getKey()).getType());
    }
}

