define("confluence-hipchat-emoticons/data/DataManager",
    [
        "ajs",
        "jquery"
    ],
    function (
        AJS,
        $) {

        var EMOTICONS_STORAGE_KEY = "hipchat.emoticons.data";

        var emoticonPromise,
            hipchatIntegrated = false,
            completableEmoticonCache = {},
            emoticonCache = { confluence: [], hipchat: []},
            hipChatEmoticons = {};       // keyed by shortcut

        var initializeHipChatEmoticons = function(rawEmoticons) {
            if(!rawEmoticons) {
                return;
            }

            hipChatEmoticons = {};

            rawEmoticons.forEach(function(emoticon) {
                hipChatEmoticons[emoticon.shortcut] = emoticon;
            });
        };

        var initializeCache = function () {
            var data = JSON.parse(localStorage.getItem(EMOTICONS_STORAGE_KEY));
            if (!data) {
                return;
            }

            hipchatIntegrated = data.hipchatIntegrated;
            emoticonCache.confluence = data.confluence;
            emoticonCache.hipchat = data.hipchat;

            initializeHipChatEmoticons(emoticonCache.hipchat);
        };

        var loadRemoteData = function() {
            var remotePromise = $.ajax({
                url: AJS.contextPath() + "/rest/emoticons/1.0/",
                type: "get",
                dataType: "json",
                cache: false
            });

            return remotePromise
                .then(function(data) {
                    // First, we put the data in local storage.
                    localStorage.setItem(EMOTICONS_STORAGE_KEY, JSON.stringify(data));
                    // Then, we initialize local structures.
                    hipchatIntegrated = data.hipchatIntegrated;
                    emoticonCache.confluence = data.confluence;
                    emoticonCache.hipchat = data.hipchat;
                    initializeHipChatEmoticons(emoticonCache.hipchat);
                    return $.Deferred().resolve(data);
                });
        };

        return {
            initializeData: function () {
                initializeCache();
                emoticonPromise = loadRemoteData();
            },

            loadRemoteData: loadRemoteData,

            // Returns a Promise that will yield the list of emoticons fetched from server.
            getAuthoritativeEmoticons: function() {
                return emoticonPromise;
            },

            getHipChatEmoticon: function(shortcut) {
                return hipChatEmoticons[shortcut];
            }
        };
    });
