define("confluence-hipchat-emoticons/dialog/DialogEmoticon",
    [
        "underscore"
    ],
    function (_) {
        var DialogEmoticon = function (options) {
            this.name = options.name;
            this.shortcut = options.shortcut;
            this.fullShortcut = options.fullShortcut;
            this.url = options.url;
            this.onClick = options.onClick && _.bind(options.onClick, this, this);
            this.visible = true;

            this._initializeCaption(options);
        };
        _.extend(DialogEmoticon.prototype, {
            onKeypress: function (ev) {
                if(ev.keyCode == 13) {
                    this.click();
                }
            },

            _initializeCaption: function (options) {
                if (options.selectedText) {
                    this.selectedCaptionPortion = options.selectedText;

                    var index = this.fullShortcut.indexOf(this.selectedCaptionPortion);

                    this.leftCaptionPortion = this.fullShortcut.substring(0, index);
                    this.rightCaptionPortion = this.fullShortcut.substring(index + this.selectedCaptionPortion.length);
                } else {
                    this.leftCaptionPortion = this.fullShortcut;
                    this.selectedCaptionPortion = "";
                    this.rightCaptionPortion = "";
                }
            }
        });

        return DialogEmoticon;
    });
