define("confluence-hipchat-emoticons/data/DataManager",
    [
        "ajs",
        "jquery"
    ],
    function (
        AJS,
        $) {

        var EMOTICONS_STORAGE_KEY = "hipchat.emoticons.data";

        var emoticonPromise,
            hipchatIntegrated = false,
            completableEmoticonCache = {},
            emoticonCache = { confluence: [], hipchat: []},
            hipChatEmoticons = {};       // keyed by shortcut

        var initializeHipChatEmoticons = function(rawEmoticons) {
            if(!rawEmoticons) {
                return;
            }

            hipChatEmoticons = {};

            rawEmoticons.forEach(function(emoticon) {
                hipChatEmoticons[emoticon.shortcut] = emoticon;
            });
        };

        var initializeCache = function () {
            var data = JSON.parse(localStorage.getItem(EMOTICONS_STORAGE_KEY));
            if (!data) {
                return;
            }

            hipchatIntegrated = data.hipchatIntegrated;
            emoticonCache.confluence = data.confluence;
            emoticonCache.hipchat = data.hipchat;

            initializeHipChatEmoticons(emoticonCache.hipchat);
        };

        var loadRemoteData = function() {
            var remotePromise = $.ajax({
                url: AJS.contextPath() + "/rest/emoticons/1.0/",
                type: "get",
                dataType: "json",
                cache: false
            });

            return remotePromise
                // First, we put the data in localstorage.
                .then(function(data) {
                    localStorage.setItem(EMOTICONS_STORAGE_KEY, JSON.stringify(data));
                })
                // Then, we initialise local structures.
                .then(function(data) {
                    hipchatIntegrated = data.hipchatIntegrated;
                    emoticonCache.confluence = data.confluence;
                    emoticonCache.hipchat = data.hipchat;
                    initializeHipChatEmoticons(emoticonCache.hipchat);
                });
        };

        return {
            initializeData: function () {
                initializeCache();
                emoticonPromise = loadRemoteData();
            },

            loadRemoteData: loadRemoteData,

            // Returns a Promise that will yield the list of emoticons fetched from server.
            getAuthoritativeEmoticons: function() {
                return emoticonPromise;
            },

            getHipChatEmoticon: function(shortcut) {
                return hipChatEmoticons[shortcut];
            }
        };
    });
