define("confluence-hipchat-emoticons/completion/Utilities",
    [
        "jquery"
    ],
    function ($) {
        return {
            /**
             * Assuming | is the caret marker the caret could be positioned as such:
             * <p><textNode>content of text node|</textNode></p>
             *                                  ^
             * or (less obviously) as such:
             * <p><textNode>content of text node</textNode>|</p>
             *                                             ^
             */
            getTextFromPreviousSiblingTextNodes: function (range) {
                var currentNode, currentOffset;
                if (!range || !range.collapsed) {
                    throw new Error("range is null or not collapsed");
                }
                currentNode = range.startContainer;
                currentOffset = range.startOffset;

                if (currentNode.nodeType == 1 && currentOffset > 0) {
                    //descend into the relevent child node
                    currentNode = currentNode.childNodes[range.startOffset - 1];
                    if (currentNode.nodeType == 3) {
                        //It's a text node so we'll use it.
                        currentOffset = currentNode.nodeValue.length;
                    } else {
                        //We're working under the assumption that the start container will never be
                        // higher than textnode.parentNode.
                        return "";
                    }
                } else if (currentNode.nodeType != 3) {
                    //not a text node or element, we can assume "".
                    return "";
                }

                var result = currentNode.nodeValue.substring(0, currentOffset);

                for (var ps = currentNode.previousSibling; ps && ps.nodeType == 3; ps = ps.previousSibling) {
                    result = ps.nodeValue + result;
                }

                return result;
            },

            getCharCode: function (nativeEvent) {
                return $.browser.msie ? nativeEvent.keyCode : nativeEvent.which;
            }
        };
    });
