/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.confluence.content.render.xhtml.editor.inline.EmoticonDisplayMapper;
import com.atlassian.confluence.plugins.hipchat.emoticons.rest.EmoticonModel;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.ConfluenceEmoticonService;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.HipChatEmoticonService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/")
@AnonymousAllowed
public class EmoticonsResource {
    private final HipChatEmoticonService hipChatEmoticonService;
    private final ConfluenceEmoticonService confluenceEmoticonService;
    private final EmoticonDisplayMapper emoticonDisplayMapper;

    public EmoticonsResource(HipChatEmoticonService hipChatEmoticonService, ConfluenceEmoticonService confluenceEmoticonService, EmoticonDisplayMapper emoticonDisplayMapper) {
        this.hipChatEmoticonService = hipChatEmoticonService;
        this.confluenceEmoticonService = confluenceEmoticonService;
        this.emoticonDisplayMapper = emoticonDisplayMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> get() {
        ImmutableSet hipChatEmoticons = Collections.emptySet();
        if (!AuthenticatedUserThreadLocal.isAnonymousUser()) {
            hipChatEmoticons = ImmutableSet.copyOf((Iterable)Iterables.transform(this.hipChatEmoticonService.list(), EmoticonModel.fromHipChatEmoticon()));
        }
        ImmutableSet confluenceEmoticons = ImmutableSet.copyOf((Iterable)Iterables.transform(this.confluenceEmoticonService.list().entrySet(), EmoticonModel.fromConfluenceEmoticon(this.emoticonDisplayMapper)));
        return ImmutableMap.builder().put((Object)"hipchatIntegrated", (Object)(!hipChatEmoticons.isEmpty() ? 1 : 0)).put((Object)"hipchat", (Object)hipChatEmoticons).put((Object)"confluence", (Object)confluenceEmoticons).build();
    }
}

