/**
 * Utility functions for working with the Documentation Theme
 * TO DO: This needs to live somewhere else, maybe the Confluence Core JS library
 */
Confluence.DocThemeUtils = Confluence.DocThemeUtils || (function($) {
    var $docThemeEl;

    function isDocTheme() {
        return (getDocThemeContentElement().length) ? true : false;
    }

    function getDocThemeContentElement() {
        if (!$docThemeEl) {
            $docThemeEl = $('#splitter-content');
        }
        return $docThemeEl;
    }

    function appendAbsolutePositionedElement(node) {
        var $node = $(node);
        $(node).appendTo(isDocTheme() ? getDocThemeContentElement() : $('body'));
        return $node;
    }

    function getMainContentScrollTop() {
        return isDocTheme() ?
            getDocThemeContentElement().scrollTop() :
            $(document).scrollTop();
    }

    function getMainContentScrollLeft() {
        return isDocTheme() ?
            getDocThemeContentElement().scrollLeft() :
            $(document).scrollLeft();
    }

    return {
        isDocTheme: isDocTheme,
        appendAbsolutePositionedElement: appendAbsolutePositionedElement,
        getMainContentScrollTop: getMainContentScrollTop,
        getMainContentScrollLeft: getMainContentScrollLeft,
        getDocThemeContentElement: getDocThemeContentElement
    }
})(AJS.$);