AJS.toInit(function($){

    var IS_NEW_COMMENT = true;
    var editorEmpty = false;
    var PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-highlight-actions:quote-comment";

    function moveCursorToEnd(editor) {
        var range = editor.getBody().createTextRange();
        range.moveToElementText(editor.getBody());
        range.collapse(false);
        range.select();
    }

    function scrollWindowToEditor() {
        var MARGIN_ABOVE_COMMENT_EDITOR = 40;
        if (Confluence.DocThemeUtils.isDocTheme()) {
            var $docThemeContainer = Confluence.DocThemeUtils.getDocThemeContentElement();
            var commentEditorTop = $docThemeContainer.scrollTop() - $('#header').height() + $("#rte-toolbar").offset().top;
            $docThemeContainer.scrollTop(commentEditorTop - MARGIN_ABOVE_COMMENT_EDITOR);
        } else {
            var commentEditorTop = $("#rte-toolbar").offset().top;
            $(document).scrollTop(commentEditorTop - MARGIN_ABOVE_COMMENT_EDITOR);
        }
    }

    function pasteQuote(editor, selectionObject) {
        var paragraphContent = '<p><br/></p>'; // default behavior of TinyMCE when user insert new paragraph in browsers other than IE
        if ($.browser.msie && !editorEmpty) {
            moveCursorToEnd(editor); // need to move cursor to end of content because IE loses cursor location when editor loses focus
            paragraphContent = '<p></p>';
        }

        var insertContent = "<blockquote><p>" + selectionObject.html + "</p></blockquote>" + paragraphContent;
        editor.execCommand('mceInsertContent', false, insertContent);
        editorEmpty = false;
    }

    function actionCallback(selectionObject) {
        Confluence.HighlightAction.clearTextSelection();

        // Need to place this in a timeout so that the panel actions have a chance to fade out before the
        // window scrolls, otherwise scrolling will break the fadeout behavior
        setTimeout(function() {
            var commentEditor = AJS && AJS.Rte && AJS.Rte.getEditor && AJS.Rte.getEditor();
            if (commentEditor) {
                Confluence.HighlightAction.Analytics.sendAnalyticsForQuoteInComment();
                // If comment editor is already loaded, need to scroll the window to the comment editor when user quotes
                scrollWindowToEditor();
                pasteQuote(commentEditor, selectionObject);
            } else {
                Confluence.HighlightAction.Analytics.sendAnalyticsForQuoteInComment(IS_NEW_COMMENT);
                editorEmpty = true;
                // Need to trigger quick edit and paste the text when
                // the quick edit form visible and "quickedit.visible" event fires
                var handler = function() {
                    pasteQuote(AJS.Rte.getEditor(), selectionObject);
                    AJS.unbind('quickedit.visible', handler);
                };
                AJS.bind('quickedit.visible', handler);

                activeEditor(quoteInsideComment(selectionObject.containingElement));
            }
        }, 0);
    }

    /**
     * Return the comment element which contains the text is quoting
     * @param selectionObject
     * @returns {*|jQuery}
     */
    function quoteInsideComment(containingElement) {
        var $commentEl = $(containingElement).closest('div.comment');

        return $commentEl;
    }

    /**
     * Active the correct editor if commentEl is passed. If not, active editor as new comment
     * @param commentEl
     */
    function activeEditor($commentEl) {
        if (!$commentEl.length > 0) {
            // Active new Editor as new comment
            $('.quick-comment-prompt').click();
        } else {
            // Active editor as reply according to commentEl
            $commentEl.find('.comment-actions .action-reply-comment').click();
        }
    }

    Confluence && Confluence.HighlightAction && Confluence.HighlightAction.registerButtonHandler(PLUGIN_KEY, {
        onClick: actionCallback,
        shouldDisplay: Confluence.HighlightAction.WORKING_AREA.MAINCONTENT_AND_COMMENT
    });
});
