/*
 * Facade service for analytics event handling
 *
 * Events we log
 *
 * when the user triggers the highlight panel
 * confluence.highlight.panel.open
 *
 * when the user clicks quote in comment with the comment editor uninitialized
 * confluence.quote.in.comment.insert
 *
 * when the user clicks quote in comment with the comment editor loaded
 * confluence.quote.in.comment.append
 */
Confluence.HighlightAction.Analytics = (function($) {
    var OPEN_HIGHLIGHT_PANEL = "confluence.highlight.actions.open";
    var QUOTE_IN_COMMENT_INSERT = "confluence.quote.in.comment.insert";
    var QUOTE_IN_COMMENT_APPEND = "confluence.quote.in.comment.append";

    function triggerEvent(name, properties) {
        AJS.trigger('analytics', {name: name, data: properties});
    }

    function sendAnalyticsForOpeningHighlightOptionPanel() {
        triggerEvent(OPEN_HIGHLIGHT_PANEL);
    }

    function sendAnalyticsForQuoteInComment(isNew) {
        if (isNew) {
            triggerEvent(QUOTE_IN_COMMENT_INSERT);
        } else {
            triggerEvent(QUOTE_IN_COMMENT_APPEND);
        }
    }

    return {
        sendAnalyticsForOpeningHighlightOptionPanel: sendAnalyticsForOpeningHighlightOptionPanel,
        sendAnalyticsForQuoteInComment: sendAnalyticsForQuoteInComment
    };
})(AJS.$);