/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.xml;

import com.atlassian.confluence.plugins.highlight.model.TextMatch;
import com.atlassian.confluence.plugins.highlight.model.TextNode;
import com.atlassian.confluence.plugins.highlight.model.XMLModification;
import com.atlassian.confluence.plugins.highlight.xml.SelectionTransformer;
import com.atlassian.confluence.plugins.highlight.xml.XMLParserHelper;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MarkSelectionTransformer
extends SelectionTransformer<XMLModification> {
    public MarkSelectionTransformer(XMLParserHelper xmlParserHelper) {
        super(xmlParserHelper);
    }

    @Override
    public boolean transform(Document document, TextMatch textMatch, XMLModification xmlModification) throws SAXException {
        int i = 1;
        boolean wrapped = false;
        List<TextNode> positions = textMatch.getMatchingNodes();
        DocumentFragment wrappingXml = this.xmlParserHelper.parseDocumentFragment(document, xmlModification.getXml());
        for (TextNode textNode : positions) {
            if (textNode.isModifiable()) {
                Node node = textNode.getNode();
                String nodeText = node.getNodeValue();
                int inNodeStartIndex = i == 1 ? textMatch.getFirstNodeStartIndex() : 0;
                int inNodeEndIndex = i == positions.size() ? textMatch.getLastNodeEndIndex() : nodeText.length();
                String textToBeWrapped = nodeText.substring(inNodeStartIndex, inNodeEndIndex);
                Node fragment = document.importNode(wrappingXml, true);
                Node wrapper = fragment.getFirstChild();
                while (wrapper.hasChildNodes()) {
                    wrapper = wrapper.getFirstChild();
                }
                wrapper.setTextContent(textToBeWrapped);
                if (inNodeStartIndex == 0 && inNodeEndIndex == nodeText.length()) {
                    node.getParentNode().replaceChild(wrapper, node);
                } else {
                    nodeText = nodeText.substring(0, inNodeStartIndex) + nodeText.substring(inNodeEndIndex, nodeText.length());
                    node.setNodeValue(nodeText);
                    this.insertContentAtIndexInTextNode(document, node, inNodeStartIndex, fragment);
                }
                wrapped = true;
            }
            ++i;
        }
        return wrapped;
    }
}

