(function($) {
    Confluence.FeatureDiscovery = {};

    var discoveredFeatures,
        featureShown = false,
        DEFAULT_MAX_VIEWS = 3;

    var pluginKey  = "com.atlassian.confluence.plugins.confluence-feature-discovery-plugin";
    var dataKey = pluginKey + ":confluence-feature-discovery-plugin-resources.test-mode";
    var testMode = WRM.data.claim(dataKey);

    function getDiscovered(pluginKey) {
        if(discoveredFeatures === undefined) {
            discoveredFeatures = JSON.parse(AJS.Meta.get("discovered-plugin-features") || "{}");
        }

        if(pluginKey) {
            return discoveredFeatures[pluginKey] || [];
        }

        return discoveredFeatures;
    }

    function isDiscovered(pluginKey, featureKey) {
        var list = getDiscovered(pluginKey);
        for (var i = 0, len = list.length; i < len; i++) {
            if (list[i] === featureKey) {
                return true;
            }
        }
        return false;
    }

    function hasDiscoveryCookie(pluginKey, featureKey) {
        var name = "com.atlassian.webdriver.discovery="+pluginKey+":"+featureKey;
        var ca = document.cookie.split(';');
        for(var i=0; i<ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) === ' ') c = c.substring(1);
            if (c.indexOf(name) !== -1) return true;
        }
        return false;
    }

    Confluence.FeatureDiscovery.forPlugin = function(pluginKey, maxViews) {
        var storage = Confluence.storageManager("feature-discovery." + pluginKey);
        maxViews = maxViews || DEFAULT_MAX_VIEWS;

        function getDiscoveryViewCount(featureKey) {
          var count = parseInt(storage.getItem(featureKey), 10);
          return isNaN(count) ? 0 : count;
        }

        function setDiscoveryViewCount(featureKey, count) {
          return storage.setItem(featureKey, count);
        }

        function removeDiscoveryViewCount(featureKey) {
          return storage.removeItem(featureKey);
        }

        return {
            addDiscoveryView: function(featureKey) {
              setDiscoveryViewCount(featureKey, getDiscoveryViewCount(featureKey) + 1);
            },
            shouldShow: function(featureKey, hideWhenTesting) {
                if (hideWhenTesting === true
                        && testMode
                        && !hasDiscoveryCookie(pluginKey, featureKey)) {
                    return false;
                }

                // If we've already said a feature should be shown, then we don't want to allow anymore for this page.
                if(featureShown || isDiscovered(pluginKey, featureKey)) {
                    return false;
                }

                if(getDiscoveryViewCount(featureKey) >= maxViews) {
                    this.markDiscovered(featureKey);
                    return false;
                }

                featureShown = true;
                return true;
            },
            markDiscovered: function(featureKey, callback) {
                if(isDiscovered(pluginKey, featureKey)) {
                    return;
                }

                AJS.safeAjax({
                    url: AJS.contextPath() + "/rest/feature-discovery/1.0/discovered/" + pluginKey + "/" + featureKey,
                    type: "POST",
                    data: {}, // AJS.safeAjax expect a data attribute in order to add the token
                    success: function() {
                        getDiscovered(pluginKey).unshift(featureKey);
                        removeDiscoveryViewCount(featureKey);
                        AJS.trigger("feature-discovered", {
                            pluginKey: pluginKey,
                            featureKey: featureKey
                        });

                        if(callback && $.isFunction(callback)) {
                            callback();
                        }
                    }
                });
            },
            listDiscovered: function() {
                // Return a copy of the discovered list.
                return getDiscovered(pluginKey).slice(0);
            }
        };
    }
})(AJS.$);
